/*
 * Decompiled with CFR 0.152.
 */
package com.ma.progression;

import com.ma.Registries;
import com.ma.api.progression.ProgressionCondition;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.eventbus.api.Event;

public class ProgressionHelper {
    public static final float PCT_ALLOWED = 0.8f;

    public static int getCompletePerTier(int tier) {
        return Math.max(Math.round((float)ProgressionHelper.getConditionsForTier(tier).size() * 0.8f), 1);
    }

    public static List<ProgressionCondition<?>> getConditionsForTier(int tier) {
        return Registries.Progression.getValues().stream().filter(p -> p.getTier() == tier).collect(Collectors.toList());
    }

    public static <T extends Event> List<ProgressionCondition<?>> getConditionsForTierExcluding(int tier, ProgressionCondition.EventType<T> type, List<ResourceLocation> toExclude) {
        return Registries.Progression.getValues().stream().filter(p -> p.getTier() == tier && p.getType() == type && !toExclude.contains(p.getRegistryName())).collect(Collectors.toList());
    }
}

