/*
 * Decompiled with CFR 0.152.
 */
package com.ma.recipes;

import com.google.gson.JsonObject;
import com.ma.ManaAndArtifice;
import com.ma.api.capabilities.Faction;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.ResourceLocation;

public abstract class AMRecipeBase
extends SpecialRecipe {
    protected int tier = 1;
    protected Faction requiredFaction = Faction.NONE;

    public AMRecipeBase(ResourceLocation idIn) {
        super(idIn);
    }

    public final void parseJSON(JsonObject object) {
        this.parseExtraJson(object);
        if (object.has("tier")) {
            this.tier = object.get("tier").getAsInt();
        } else {
            ManaAndArtifice.LOGGER.warn("Recipe " + this.func_199560_c().toString() + " does not define a tier, defaulting to 1.");
        }
        if (object.has("requiredFaction")) {
            this.requiredFaction = Faction.valueOf(Faction.class, object.get("requiredFaction").getAsString());
        }
        this.runValidation();
    }

    protected abstract void parseExtraJson(JsonObject var1);

    public final int getTier() {
        return this.tier;
    }

    public abstract ItemStack getGuiRepresentationStack();

    public Faction getFactionRequirement() {
        return this.requiredFaction;
    }

    public void setRequiredFaction(int factionOrdinal) {
        this.requiredFaction = factionOrdinal > -1 && factionOrdinal < Faction.values().length ? Faction.values()[factionOrdinal] : Faction.NONE;
    }

    protected void runValidation() {
    }
}

