/*
 * Decompiled with CFR 0.152.
 */
package com.ma.recipes.arcanefurnace;

import com.google.gson.JsonObject;
import com.ma.ManaAndArtifice;
import com.ma.recipes.AMRecipeBaseSerializer;
import com.ma.recipes.arcanefurnace.ArcaneFurnaceRecipe;
import java.util.function.Function;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class ArcaneFurnaceRecipeSerializer
extends AMRecipeBaseSerializer<ArcaneFurnaceRecipe> {
    public ArcaneFurnaceRecipeSerializer(Function<ResourceLocation, ArcaneFurnaceRecipe> patternMap) {
        super(patternMap);
    }

    @Override
    public ArcaneFurnaceRecipe readExtra(ResourceLocation recipeId, JsonObject json) {
        ArcaneFurnaceRecipe recipe = new ArcaneFurnaceRecipe(recipeId);
        recipe.parseJSON(json);
        return recipe;
    }

    @Override
    public ArcaneFurnaceRecipe readExtra(ResourceLocation recipeId, PacketBuffer buffer) {
        try {
            ArcaneFurnaceRecipe recipe = new ArcaneFurnaceRecipe(recipeId);
            recipe.setInputItem(buffer.func_192575_l());
            recipe.setOutputItem(buffer.func_192575_l());
            recipe.setBurnTime(buffer.readInt());
            recipe.setOutputQuantity(buffer.readInt());
            return recipe;
        }
        catch (Exception e) {
            ManaAndArtifice.LOGGER.error("Error reading arcane furnace recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void writeExtra(PacketBuffer buffer, ArcaneFurnaceRecipe recipe) {
        try {
            buffer.func_192572_a(recipe.getInputItem());
            buffer.func_192572_a(recipe.getOutputItem());
            buffer.writeInt(recipe.getBurnTime());
            buffer.writeInt(recipe.getOutputQuantity());
        }
        catch (Exception e) {
            ManaAndArtifice.LOGGER.error("Error writing arcane furnace recipe to packet.", (Throwable)e);
            throw e;
        }
    }
}

