/*
 * Decompiled with CFR 0.152.
 */
package com.ma.recipes.manaweaving;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ma.ManaAndArtifice;
import com.ma.api.recipes.IManaweavePattern;
import com.ma.items.ItemInit;
import com.ma.recipes.AMRecipeBase;
import com.ma.recipes.RecipeInit;
import com.ma.recipes.manaweaving.ManaweavingPatternHelper;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ManaweavingPattern
extends AMRecipeBase
implements IManaweavePattern {
    private byte[][] pattern;
    private int xBound;
    private int yBound;

    public ManaweavingPattern(ResourceLocation idIn) {
        super(idIn);
    }

    @Override
    public void parseExtraJson(JsonObject jsonobject) {
        JsonArray arr = jsonobject.getAsJsonArray("pattern");
        this.pattern = new byte[arr.size()][];
        for (int i = 0; i < arr.size(); ++i) {
            JsonElement elem = arr.get(i);
            if (!elem.isJsonArray()) continue;
            JsonArray subArr = elem.getAsJsonArray();
            this.pattern[i] = new byte[subArr.size()];
            for (int j = 0; j < subArr.size(); ++j) {
                this.pattern[i][j] = subArr.get(j).getAsByte();
            }
        }
        this.initializePattern();
    }

    private void initializePattern() {
        if (this.pattern.length == 0) {
            ManaAndArtifice.LOGGER.error("Manaweaving pattern {0} has a length of 0 - this won't work right!", (Object)this.func_199560_c());
            this.xBound = 0;
            this.yBound = 0;
            return;
        }
        this.xBound = this.pattern.length;
        this.yBound = this.pattern[0].length;
        for (int i = 1; i < this.pattern.length; ++i) {
            if (this.pattern[i].length == this.yBound) continue;
            this.pattern = new byte[0][];
            this.xBound = 0;
            this.yBound = 0;
            ManaAndArtifice.LOGGER.error("Manaweaving pattern {0}: array secondary dimension arrays must all be the same length.", (Object)this.func_199560_c());
            return;
        }
    }

    @Override
    public byte[][] get() {
        return this.pattern;
    }

    public void setPatternBytes(byte[][] value) {
        this.pattern = value;
        this.initializePattern();
    }

    private final byte[][] blank() {
        byte[][] comp = new byte[this.pattern.length][];
        for (int i = 0; i < comp.length; ++i) {
            comp[i] = new byte[this.pattern[i].length];
        }
        return comp;
    }

    public static final ManaweavingPattern match(World world, Vector3f[] points, Vector3f[] directions) {
        float highestScore = 0.0f;
        ManaweavingPattern current = null;
        for (ManaweavingPattern recipe : ManaweavingPatternHelper.getAllPatterns(world)) {
            float score = ManaweavingPattern.match(world, recipe, points, directions);
            ManaAndArtifice.LOGGER.info(recipe.func_199560_c().toString() + " score: " + score);
            if (!(score > highestScore)) continue;
            highestScore = score;
            current = recipe;
        }
        return highestScore > 0.7f ? current : null;
    }

    private static final float match(World world, ManaweavingPattern pattern, Vector3f[] points, Vector3f[] directions) {
        byte[][] comp = pattern.blank();
        Vector3f[] __points = new Vector3f[points.length];
        for (int i = 0; i < points.length; ++i) {
            __points[i] = points[i].func_229195_e_();
        }
        Vector3f min = new Vector3f(2.1474836E9f, 2.1474836E9f, 2.1474836E9f);
        Vector3f max = new Vector3f(-2.1474836E9f, -2.1474836E9f, -2.1474836E9f);
        ManaweavingPattern.projectPointsAlongZ(__points, directions, min, max);
        for (int i = 0; i < __points.length; ++i) {
            __points[i].setX((__points[i].func_195899_a() - min.func_195899_a()) / (max.func_195899_a() - min.func_195899_a()));
            __points[i].setY((__points[i].func_195900_b() - min.func_195900_b()) / (max.func_195900_b() - min.func_195900_b()));
            int x = (int)Math.floor(__points[i].func_195899_a() * (float)pattern.xBound);
            int y = (int)Math.floor(__points[i].func_195900_b() * (float)pattern.yBound);
            if (x >= pattern.xBound || x < 0 || y >= pattern.yBound || y < 0) continue;
            comp[x][y] = 1;
        }
        int M = comp.length;
        int N = comp[0].length;
        byte[][] ret = new byte[N][M];
        for (int r = 0; r < M; ++r) {
            for (int c = 0; c < N; ++c) {
                ret[r][c] = comp[c][M - 1 - r];
            }
        }
        return ManaweavingPattern.getArrayCompareScore(ret, pattern.get(), __points.length);
    }

    private static float getArrayCompareScore(byte[][] arrayFromWorld, byte[][] compareTo, int numPoints) {
        if (arrayFromWorld.length != compareTo.length) {
            return 0.0f;
        }
        boolean radius = true;
        float radialWeight = 0.25f;
        float maxScore = 0.0f;
        for (int i = 0; i < compareTo.length; ++i) {
            for (int j = 0; j < compareTo[i].length; ++j) {
                if (compareTo[i][j] != 1) continue;
                maxScore += 1.0f;
            }
        }
        if (maxScore == 0.0f) {
            maxScore = 1.0f;
        }
        float score = 0.0f;
        for (int i = 0; i < compareTo.length; ++i) {
            for (int j = 0; j < compareTo[i].length; ++j) {
                if (arrayFromWorld[i].length != compareTo[i].length) {
                    return 0.0f;
                }
                if (compareTo[i][j] != 1) continue;
                if (arrayFromWorld[i][j] == 1) {
                    score += 1.0f;
                }
                for (int k = -1; k <= 1; ++k) {
                    for (int l = -1; l <= 1; ++l) {
                        if (i + k < 0 || i + k >= arrayFromWorld.length || j + l < 0 || j + l >= arrayFromWorld.length || k == 0 && l == 0 || compareTo[i + k][j + l] != 1 || arrayFromWorld[i + k][j + l] != 1) continue;
                        score += 0.25f;
                    }
                }
            }
        }
        return score / maxScore;
    }

    private static void projectPointsAlongZ(Vector3f[] points, Vector3f[] directions, Vector3f out_min, Vector3f out_max) {
        Vector3f c = points[0].func_229195_e_();
        for (int i = 0; i < points.length; ++i) {
            float yaw = directions[i].func_195899_a();
            float pitch = directions[i].func_195900_b();
            points[i].func_195897_a(c);
            points[i].func_214905_a(Vector3f.field_229179_b_.func_229187_a_(pitch));
            points[i].func_214905_a(Vector3f.field_229181_d_.func_229187_a_(yaw));
            points[i].func_229189_a_(c);
            out_min.setX(Math.min(out_min.func_195899_a(), points[i].func_195899_a()));
            out_min.setY(Math.min(out_min.func_195900_b(), points[i].func_195900_b()));
            out_min.setZ(Math.min(out_min.func_195902_c(), points[i].func_195902_c()));
            out_max.setX(Math.max(out_max.func_195899_a(), points[i].func_195899_a()));
            out_max.setY(Math.max(out_max.func_195900_b(), points[i].func_195900_b()));
            out_max.setZ(Math.max(out_max.func_195902_c(), points[i].func_195902_c()));
        }
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        return inv.func_174922_i() == 1 && inv.func_174923_h() == 1 && inv.func_70301_a(0).func_77973_b() == ItemInit.MANAWEAVER_DUMMY_ITEM.get();
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)RecipeInit.MANAWEAVING_SERIALIZER.get();
    }

    public IRecipeType<?> func_222127_g() {
        return RecipeInit.MANAWEAVING_PATTERN_TYPE;
    }

    @Override
    public ItemStack getGuiRepresentationStack() {
        ItemStack stack = new ItemStack((IItemProvider)ItemInit.MANAWEAVER_WAND.get());
        stack.func_200302_a((ITextComponent)new TranslationTextComponent(this.func_199560_c().toString()));
        return stack;
    }

    @Override
    public ManaweavingPattern copy() {
        ManaweavingPattern clone = new ManaweavingPattern(this.func_199560_c());
        clone.setPatternBytes(this.pattern);
        return clone;
    }
}

