/*
 * Decompiled with CFR 0.152.
 */
package com.ma.recipes.rituals;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ma.ManaAndArtifice;
import com.ma.api.recipes.IRitualRecipe;
import com.ma.api.rituals.IRitualReagent;
import com.ma.api.rituals.RitualBlockPos;
import com.ma.blocks.ritual.BlockChalkRune;
import com.ma.items.ItemInit;
import com.ma.recipes.AMRecipeBase;
import com.ma.recipes.RecipeInit;
import com.ma.recipes.rituals.RitualRecipeHelper;
import com.ma.rituals.MatchedRitual;
import com.ma.rituals.RitualReagent;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class RitualRecipe
extends AMRecipeBase
implements IRitualRecipe {
    private long innerColor = 0xFFFFFFL;
    private long outerColor = 65280L;
    private long beamColor = 0xFFFFFFL;
    private boolean connectBeam = true;
    private boolean displayIndexes = true;
    private boolean kittable = true;
    private boolean isValid;
    private int[][] pattern;
    private int[][] displayPattern;
    private RitualReagent[][] reagents;
    private String[] manaweave_patterns;
    private int RITUAL_SIZE;

    public RitualRecipe(ResourceLocation id) {
        super(id);
    }

    public ItemStack func_77571_b() {
        ItemStack output = new ItemStack((IItemProvider)ItemInit.RUNE_RITUAL_METAL.get());
        output.func_200302_a((ITextComponent)new TranslationTextComponent(this.func_199560_c().toString()));
        return output;
    }

    @Override
    public void parseExtraJson(JsonObject json) {
        if (!(json.has("keys") && json.has("pattern") && json.has("reagents") && json.get("pattern").isJsonArray() && json.get("reagents").isJsonArray() && json.get("keys").isJsonObject())) {
            ManaAndArtifice.LOGGER.error("Malformed JSON for ritual recipe (" + this.func_199560_c().toString() + ").  Missing critical elements.  It was NOT loaded!");
            this.isValid = false;
            return;
        }
        JsonArray patternData = json.get("pattern").getAsJsonArray();
        try {
            this.pattern = this.parsePatternArray(patternData);
            if (this.pattern.length == 0) {
                this.isValid = false;
                return;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.isValid = false;
            return;
        }
        if (json.has("displayPattern")) {
            JsonArray displayPatternData = json.get("displayPattern").getAsJsonArray();
            try {
                this.displayPattern = this.parsePatternArray(displayPatternData);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.displayPattern = this.pattern;
                ManaAndArtifice.LOGGER.error("Malformed display pattern JSON for ritual recipe (" + this.func_199560_c().toString() + ").  Falling back to main pattern for display.");
            }
        } else {
            this.displayPattern = this.pattern;
        }
        JsonObject reagentKeys = json.get("keys").getAsJsonObject();
        JsonArray reagentData = json.get("reagents").getAsJsonArray();
        try {
            if (!this.parseReagentArray(reagentData, reagentKeys)) {
                this.isValid = false;
                return;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.isValid = false;
            return;
        }
        if (json.has("manaweave")) {
            try {
                JsonElement manaweave = json.get("manaweave");
                this.parseManaweave(manaweave);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.isValid = false;
                return;
            }
        } else {
            this.manaweave_patterns = new String[0];
        }
        if (json.has("parameters")) {
            try {
                JsonObject params = json.get("parameters").getAsJsonObject();
                this.parseParameters(params);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.isValid = false;
                return;
            }
        }
        if (!this.validatePatternArray(this.pattern)) {
            ManaAndArtifice.LOGGER.error("Error parsing pattern " + this.func_199560_c().toString() + ". Ritual pattern must be square.  Pattern size: " + this.RITUAL_SIZE + "x" + this.RITUAL_SIZE + ".");
            this.isValid = false;
            return;
        }
        if (!this.validateDisplayPatternArray(this.displayPattern)) {
            ManaAndArtifice.LOGGER.error("Error parsing display pattern " + this.func_199560_c().toString() + ". Ritual display pattern must be the same size as the main pattern array.  Pattern size: " + this.RITUAL_SIZE + "x" + this.RITUAL_SIZE + ".");
            this.isValid = false;
            return;
        }
        if (!this.validateReagentArray(this.reagents, this.pattern)) {
            ManaAndArtifice.LOGGER.error("Error parsing pattern " + this.func_199560_c().toString() + ". Reagent array must be the same size as the pattern array, and reagent locations must correspond to the same non-zero elements in the pattern array.");
            this.isValid = false;
            return;
        }
        this.isValid = true;
    }

    private void parseManaweave(JsonElement manaweave) {
        if (manaweave.isJsonArray()) {
            JsonArray manaweave_array = manaweave.getAsJsonArray();
            this.manaweave_patterns = new String[manaweave_array.size()];
            for (int i = 0; i < manaweave_array.size(); ++i) {
                this.manaweave_patterns[i] = manaweave_array.get(i).getAsString();
            }
        } else {
            this.manaweave_patterns = new String[0];
        }
    }

    private void parseParameters(JsonObject parameters) {
        if (parameters.has("innerColor")) {
            this.innerColor = Long.decode(parameters.get("innerColor").getAsString());
        }
        if (parameters.has("outerColor")) {
            this.outerColor = Long.decode(parameters.get("outerColor").getAsString());
        }
        if (parameters.has("beamColor")) {
            this.beamColor = Long.decode(parameters.get("beamColor").getAsString());
        }
        if (parameters.has("connectBeam")) {
            this.connectBeam = parameters.get("connectBeam").getAsBoolean();
        }
        if (parameters.has("displayIndexes")) {
            this.displayIndexes = parameters.get("displayIndexes").getAsBoolean();
        }
        if (parameters.has("kittable")) {
            this.kittable = parameters.get("kittable").getAsBoolean();
        }
        this.tier = parameters.has("tier") ? parameters.get("tier").getAsInt() : 0;
    }

    private int[][] parsePatternArray(JsonArray patternData) {
        int[][] output = new int[patternData.size()][];
        for (int i = 0; i < patternData.size(); ++i) {
            JsonElement subElem = patternData.get(i);
            if (subElem.isJsonArray()) {
                JsonArray subArray = subElem.getAsJsonArray();
                output[i] = new int[subArray.size()];
                for (int j = 0; j < subArray.size(); ++j) {
                    JsonElement elem = subArray.get(j);
                    output[i][j] = elem.getAsInt();
                }
                continue;
            }
            ManaAndArtifice.LOGGER.error("Malformed pattern JSON for ritual recipe (" + this.func_199560_c().toString() + ").  Sub element is not an array.");
            return new int[0][];
        }
        return output;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parseReagentArray(JsonArray reagentPatterns, JsonObject keyData) {
        HashMap<Character, RitualReagent> keys = new HashMap<Character, RitualReagent>();
        if (reagentPatterns.size() != this.pattern.length) {
            return false;
        }
        this.reagents = new RitualReagent[reagentPatterns.size()][];
        int i = 0;
        while (i < reagentPatterns.size()) {
            JsonElement elem = reagentPatterns.get(i);
            if (!elem.isJsonPrimitive()) {
                return false;
            }
            char[] cArr = elem.getAsString().toCharArray();
            this.reagents[i] = new RitualReagent[cArr.length];
            for (int j = 0; j < cArr.length; ++j) {
                RitualReagent rr = null;
                if (cArr[j] != ' ') {
                    if (!keys.containsKey(Character.valueOf(cArr[j]))) {
                        JsonObject subObj;
                        String key = String.valueOf(cArr[j]);
                        if (!keyData.has(key)) {
                            ManaAndArtifice.LOGGER.error("Missing pattern map in ritual (" + this.func_199560_c().toString() + ") - key '" + key + "' is undefined.");
                            return false;
                        }
                        JsonElement subElem = keyData.get(key);
                        if (subElem.isJsonObject() && (subObj = subElem.getAsJsonObject()).has("item")) {
                            rr = new RitualReagent(subObj.get("item").getAsString());
                            if (subObj.has("optional") && subObj.get("optional").getAsBoolean()) {
                                rr.asOptional();
                            }
                            if (subObj.has("consume") && !subObj.get("consume").getAsBoolean()) {
                                rr.noConsume();
                            }
                            if (subObj.has("is_dynamic") && subObj.get("is_dynamic").getAsBoolean()) {
                                rr.asDynamic();
                            }
                            if (subObj.has("dynamic_source") && subObj.get("dynamic_source").getAsBoolean()) {
                                rr.asDynamicSource();
                            }
                            keys.put(Character.valueOf(cArr[j]), rr);
                        }
                    } else {
                        rr = (RitualReagent)keys.get(Character.valueOf(cArr[j]));
                    }
                }
                this.reagents[i][j] = rr;
            }
            ++i;
        }
        return true;
    }

    @Nullable
    private RitualReagent parseReagentKey(JsonObject key) {
        JsonElement itemObj = key.get("item");
        JsonElement optionalObj = key.get("optional");
        JsonElement consumeObj = key.get("consume");
        if (itemObj == null) {
            return null;
        }
        RitualReagent rr = new RitualReagent(itemObj.getAsString());
        if (optionalObj != null && optionalObj.getAsBoolean()) {
            rr.asOptional();
        }
        if (consumeObj != null && !consumeObj.getAsBoolean()) {
            rr.noConsume();
        }
        return rr;
    }

    CompoundNBT reagentsToNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("length", this.reagents.length);
        for (int i = 0; i < this.reagents.length; ++i) {
            for (int j = 0; j < this.reagents[i].length; ++j) {
                if (this.reagents[i][j] == null) continue;
                CompoundNBT reagentData = new CompoundNBT();
                this.reagents[i][j].writeToNBT(reagentData);
                nbt.func_218657_a("r" + i + "_" + j, (INBT)reagentData);
            }
        }
        return nbt;
    }

    void reagentsFromNBT(CompoundNBT nbt) {
        if (!nbt.func_74764_b("length")) {
            return;
        }
        int length = nbt.func_74762_e("length");
        this.reagents = new RitualReagent[length][];
        for (int i = 0; i < length; ++i) {
            this.reagents[i] = new RitualReagent[length];
            for (int j = 0; j < length; ++j) {
                if (nbt.func_74764_b("r" + i + "_" + j)) {
                    CompoundNBT reagentData = nbt.func_74775_l("r" + i + "_" + j);
                    this.reagents[i][j] = RitualReagent.fromNBT(reagentData);
                    continue;
                }
                this.reagents[i][j] = null;
            }
        }
        if (!this.validateReagentArray(this.reagents, this.pattern)) {
            throw new InvalidParameterException("Error parsing pattern " + this.func_199560_c().toString() + ". Reagent array must be the same size as the pattern array, and reagent locations must correspond to the same non-zero elements in the pattern array.");
        }
    }

    @Override
    public int[][] getPattern() {
        return this.pattern;
    }

    void setPattern(int[][] pattern) {
        this.pattern = pattern;
        if (!this.validatePatternArray(pattern)) {
            throw new InvalidParameterException("Error parsing pattern " + this.func_199560_c().toString() + ". Ritual pattern must be square.  Pattern size: " + this.RITUAL_SIZE + "x" + this.RITUAL_SIZE + ".");
        }
        assert (this.RITUAL_SIZE % 2 != 0);
        this.isValid = true;
    }

    public int[][] getDisplayPattern() {
        return this.displayPattern;
    }

    void setDisplayPattern(int[][] displayPattern) {
        this.displayPattern = displayPattern;
    }

    @Override
    public IRitualReagent[][] getReagents() {
        return this.reagents;
    }

    void setReagents(RitualReagent[][] reagents) {
        this.reagents = reagents;
        if (!this.validateReagentArray(reagents, this.pattern)) {
            throw new InvalidParameterException("Error parsing pattern " + this.func_199560_c().toString() + ". Reagent array must be the same size as the pattern array, and reagent locations must correspond to the same non-zero elements in the pattern array.");
        }
        this.isValid = true;
    }

    @Override
    public int getLowerBound() {
        return (int)Math.floor((float)this.RITUAL_SIZE / 2.0f);
    }

    public RitualReagent[] AllReagents() {
        ArrayList<RitualReagent> list = new ArrayList<RitualReagent>();
        for (int i = 0; i < this.reagents.length; ++i) {
            for (int j = 0; j < this.reagents[i].length; ++j) {
                if (this.reagents[i][j] == null) continue;
                list.add(this.reagents[i][j]);
            }
        }
        RitualReagent[] output = new RitualReagent[list.size()];
        return list.toArray(output);
    }

    @Override
    public int countRunes() {
        int count = 0;
        for (int i = 0; i < this.pattern.length; ++i) {
            for (int j = 0; j < this.pattern[i].length; ++j) {
                if (this.pattern[i][j] == 0) continue;
                ++count;
            }
        }
        return count;
    }

    public long getInnerColor() {
        return this.innerColor;
    }

    public long getBeamColor() {
        return this.beamColor;
    }

    void setBeamColor(long beamColor) {
        this.beamColor = beamColor;
    }

    void setInnerColor(long innerColor) {
        this.innerColor = innerColor;
    }

    public long getOuterColor() {
        return this.outerColor;
    }

    void setOuterColor(long outerColor) {
        this.outerColor = outerColor;
    }

    public boolean getConnectBeam() {
        return this.connectBeam;
    }

    void setConnectBeam(boolean connectBeam) {
        this.connectBeam = connectBeam;
    }

    public boolean getIsKittable() {
        return this.kittable;
    }

    void setKittable(boolean kittable) {
        this.kittable = kittable;
    }

    public boolean getDisplayIndexes() {
        return this.displayIndexes;
    }

    public void setDisplayIndexes(boolean displayIndexes) {
        this.displayIndexes = displayIndexes;
    }

    @Override
    public String[] getManaweavePatterns() {
        return this.manaweave_patterns;
    }

    void setManaweavePatterns(String[] patterns) {
        this.manaweave_patterns = patterns;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public ItemStack getGuiRepresentationStack() {
        return this.func_77571_b();
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)RecipeInit.RITUAL_SERIALIZER.get();
    }

    public IRecipeType<?> func_222127_g() {
        return RecipeInit.RITUAL_TYPE;
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        return true;
    }

    public static RitualRecipe find(World world, ResourceLocation name) {
        return RitualRecipeHelper.GetRitualRecipe(world, name);
    }

    @Nullable
    public static MatchedRitual matchAnyInWorld(BlockPos center, World world) {
        Collection<RitualRecipe> rituals = RitualRecipeHelper.getAllRituals(world);
        for (RitualRecipe ritual : rituals) {
            NonNullList<RitualBlockPos> matchedPositions = ritual.matchInWorld(center, world);
            if (matchedPositions == null) continue;
            return new MatchedRitual(matchedPositions, ritual, center);
        }
        return null;
    }

    @Override
    @Nullable
    public Direction getMatchedDirection(World world, BlockPos center) {
        if (!this.isValid) {
            return null;
        }
        if (this.matchInWorld(center, world, this.pattern)) {
            return Direction.NORTH;
        }
        int[][] rot90 = this.rotateNumberArrayCW(this.pattern);
        if (this.matchInWorld(center, world, rot90)) {
            return Direction.EAST;
        }
        int[][] rot180 = this.rotateNumberArrayCW(rot90);
        if (this.matchInWorld(center, world, rot180)) {
            return Direction.SOUTH;
        }
        int[][] rot270 = this.rotateNumberArrayCW(rot180);
        if (this.matchInWorld(center, world, rot270)) {
            return Direction.WEST;
        }
        return null;
    }

    public boolean isRuneAtOffset(int x, int y) {
        if (x < 0 || x >= this.RITUAL_SIZE || y < 0 || y >= this.RITUAL_SIZE) {
            return false;
        }
        return this.pattern[x][y] != 0;
    }

    @Nullable
    public RitualReagent getReagentAtOffset(int x, int y) {
        if (x < 0 || x >= this.RITUAL_SIZE || y < 0 || y >= this.RITUAL_SIZE) {
            return null;
        }
        return this.reagents[x][y];
    }

    public NonNullList<RitualBlockPos> matchInWorld(BlockPos center, World world) {
        if (!this.isValid) {
            return null;
        }
        if (this.matchInWorld(center, world, this.pattern)) {
            return this.getBlockPositions(center, this.pattern, this.displayPattern, this.reagents);
        }
        int[][] rot90 = this.rotateNumberArrayCW(this.pattern);
        int[][] dRot90 = this.rotateNumberArrayCW(this.displayPattern);
        RitualReagent[][] rot90rLoc = this.rotateReagentsCW(this.reagents);
        if (this.matchInWorld(center, world, rot90)) {
            return this.getBlockPositions(center, rot90, dRot90, rot90rLoc);
        }
        int[][] rot180 = this.rotateNumberArrayCW(rot90);
        int[][] dRot180 = this.rotateNumberArrayCW(dRot90);
        RitualReagent[][] rot180rLoc = this.rotateReagentsCW(rot90rLoc);
        if (this.matchInWorld(center, world, rot180)) {
            return this.getBlockPositions(center, rot180, dRot180, rot180rLoc);
        }
        int[][] rot270 = this.rotateNumberArrayCW(rot180);
        int[][] dRot270 = this.rotateNumberArrayCW(dRot180);
        RitualReagent[][] rot270rLoc = this.rotateReagentsCW(rot180rLoc);
        if (this.matchInWorld(center, world, rot270)) {
            return this.getBlockPositions(center, rot270, dRot270, rot270rLoc);
        }
        return null;
    }

    private int[][] rotateNumberArrayCW(int[][] mat) {
        int M = mat.length;
        int N = mat[0].length;
        int[][] ret = new int[N][M];
        for (int r = 0; r < M; ++r) {
            for (int c = 0; c < N; ++c) {
                ret[c][M - 1 - r] = mat[r][c];
            }
        }
        return ret;
    }

    private RitualReagent[][] rotateReagentsCW(RitualReagent[][] mat) {
        int M = mat.length;
        int N = mat[0].length;
        RitualReagent[][] ret = new RitualReagent[N][M];
        for (int r = 0; r < M; ++r) {
            for (int c = 0; c < N; ++c) {
                ret[c][M - 1 - r] = mat[r][c];
            }
        }
        return ret;
    }

    private boolean validatePatternArray(int[][] array) {
        this.RITUAL_SIZE = array.length;
        for (int i = 0; i < array.length; ++i) {
            if (array[i].length == this.RITUAL_SIZE) continue;
            return false;
        }
        return true;
    }

    private boolean validateDisplayPatternArray(int[][] array) {
        if (array.length != this.pattern.length) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i].length == this.pattern[i].length) continue;
            return false;
        }
        return true;
    }

    private boolean validateReagentArray(RitualReagent[][] array, int[][] pattern) {
        if (array.length != this.RITUAL_SIZE) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i].length == this.RITUAL_SIZE) continue;
            return false;
        }
        boolean dynamicSourceFound = false;
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                if (array[i][j] == null) continue;
                if (pattern[i][j] == 0) {
                    return false;
                }
                if (!array[i][j].isDynamicSource()) continue;
                if (dynamicSourceFound) {
                    ManaAndArtifice.LOGGER.error("Ritual recipe " + this.func_199560_c().toString() + " has more than one dynamic source defined - there can only be one.");
                    this.isValid = false;
                    return false;
                }
                dynamicSourceFound = true;
            }
        }
        return true;
    }

    private boolean matchInWorld(BlockPos center, World world, int[][] pattern) {
        int bound = this.getLowerBound();
        for (int i = -bound; i <= bound; ++i) {
            for (int j = -bound; j <= bound; ++j) {
                boolean checkValue = world.func_180495_p(center.func_177982_a(i, 0, j)).func_177230_c() instanceof BlockChalkRune;
                if (!(pattern[i + bound][j + bound] == 0 ? checkValue : !checkValue)) continue;
                return false;
            }
        }
        return true;
    }

    private NonNullList<RitualBlockPos> getBlockPositions(BlockPos center, int[][] pattern, int[][] displayPattern, RitualReagent[][] reagents) {
        NonNullList positions = NonNullList.func_191196_a();
        int bound = this.getLowerBound();
        for (int i = -bound; i <= bound; ++i) {
            for (int j = -bound; j <= bound; ++j) {
                if (pattern[i + bound][j + bound] == 0) continue;
                positions.add((Object)new RitualBlockPos(pattern[i + bound][j + bound], displayPattern[i + bound][j + bound], new BlockPos(center.func_177958_n() + i, center.func_177956_o(), center.func_177952_p() + j), reagents[i + bound][j + bound]));
            }
        }
        return positions;
    }
}

