/*
 * Decompiled with CFR 0.152.
 */
package com.ma.recipes.rituals;

import com.google.gson.JsonObject;
import com.ma.ManaAndArtifice;
import com.ma.recipes.AMRecipeBaseSerializer;
import com.ma.recipes.rituals.RitualRecipe;
import java.util.function.Function;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class RitualRecipeSerializer
extends AMRecipeBaseSerializer<RitualRecipe> {
    public RitualRecipeSerializer(Function<ResourceLocation, RitualRecipe> patternMap) {
        super(patternMap);
    }

    @Override
    public RitualRecipe readExtra(ResourceLocation recipeId, JsonObject json) {
        RitualRecipe recipe = new RitualRecipe(recipeId);
        recipe.parseJSON(json);
        return recipe;
    }

    @Override
    public RitualRecipe readExtra(ResourceLocation recipeId, PacketBuffer buffer) {
        try {
            RitualRecipe recipe = new RitualRecipe(recipeId);
            recipe.setConnectBeam(buffer.readBoolean());
            recipe.setDisplayIndexes(buffer.readBoolean());
            recipe.setInnerColor(buffer.readLong());
            recipe.setOuterColor(buffer.readLong());
            recipe.setBeamColor(buffer.readLong());
            int[][] pattern = new int[buffer.func_150792_a()][];
            for (int i = 0; i < pattern.length; ++i) {
                pattern[i] = buffer.func_186863_b();
            }
            recipe.setPattern(pattern);
            int[][] displayPattern = new int[buffer.func_150792_a()][];
            for (int i = 0; i < displayPattern.length; ++i) {
                displayPattern[i] = buffer.func_186863_b();
            }
            recipe.setDisplayPattern(displayPattern);
            recipe.reagentsFromNBT(buffer.func_150793_b());
            int pattern_count = buffer.readInt();
            String[] manaweave_patterns = new String[pattern_count];
            for (int i = 0; i < pattern_count; ++i) {
                manaweave_patterns[i] = buffer.func_218666_n();
            }
            recipe.setManaweavePatterns(manaweave_patterns);
            return recipe;
        }
        catch (Exception e) {
            ManaAndArtifice.LOGGER.error("Error reading ritual recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void writeExtra(PacketBuffer buffer, RitualRecipe recipe) {
        try {
            int i;
            buffer.writeBoolean(recipe.getConnectBeam());
            buffer.writeBoolean(recipe.getDisplayIndexes());
            buffer.writeLong(recipe.getInnerColor());
            buffer.writeLong(recipe.getOuterColor());
            buffer.writeLong(recipe.getBeamColor());
            buffer.func_150787_b(recipe.getPattern().length);
            for (i = 0; i < recipe.getPattern().length; ++i) {
                buffer.func_186875_a(recipe.getPattern()[i]);
            }
            buffer.func_150787_b(recipe.getDisplayPattern().length);
            for (i = 0; i < recipe.getDisplayPattern().length; ++i) {
                buffer.func_186875_a(recipe.getDisplayPattern()[i]);
            }
            buffer.func_150786_a(recipe.reagentsToNBT());
            buffer.writeInt(recipe.getManaweavePatterns().length);
            for (i = 0; i < recipe.getManaweavePatterns().length; ++i) {
                buffer.func_180714_a(recipe.getManaweavePatterns()[i]);
            }
        }
        catch (Exception e) {
            ManaAndArtifice.LOGGER.error("Error writing ritual recipe to packet.", (Throwable)e);
            throw e;
        }
    }
}

