/*
 * Decompiled with CFR 0.152.
 */
package com.ma.recipes.runeforging;

import com.google.gson.JsonObject;
import com.ma.api.recipes.IRuneforgeRecipe;
import com.ma.items.ItemInit;
import com.ma.recipes.AMRecipeBase;
import com.ma.recipes.RecipeInit;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;

public class RuneforgingRecipe
extends AMRecipeBase
implements IRuneforgeRecipe {
    private ResourceLocation patternItem = new ResourceLocation("");
    private ResourceLocation runeItem = new ResourceLocation("");
    private ResourceLocation materialItem;
    private Item __outputItem = null;
    private int hits = 10;
    private int outputQuantity = 1;

    public RuneforgingRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    @Override
    public void parseExtraJson(JsonObject recipeJSON) {
        this.patternItem = new ResourceLocation(recipeJSON.get("pattern").getAsString());
        this.runeItem = new ResourceLocation(recipeJSON.get("output").getAsString());
        if (recipeJSON.has("material")) {
            this.materialItem = new ResourceLocation(recipeJSON.get("material").getAsString());
        }
        if (recipeJSON.has("hits")) {
            this.hits = recipeJSON.get("hits").getAsInt();
        }
        if (recipeJSON.has("output_quantity")) {
            this.outputQuantity = recipeJSON.get("output_quantity").getAsInt();
        }
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        ItemStack patternStack = inv.func_70301_a(0);
        ItemStack materialStack = inv.func_70301_a(1);
        return inv.func_70302_i_() == 2 && patternStack.func_77973_b().getRegistryName().compareTo(this.patternItem) == 0 && (this.materialItem == null ? materialStack.func_77973_b() == ItemInit.VINTEUM_INGOT_SUPERHEATED.get() : materialStack.func_77973_b().getRegistryName().compareTo(this.materialItem) == 0);
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        return this.func_77571_b();
    }

    public ItemStack func_77571_b() {
        IForgeRegistry itemRegistry;
        if (this.__outputItem == null && (itemRegistry = GameRegistry.findRegistry(Item.class)) != null) {
            this.__outputItem = (Item)itemRegistry.getValue(this.runeItem);
        }
        if (this.__outputItem != null) {
            return new ItemStack((IItemProvider)this.__outputItem, this.outputQuantity);
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)RecipeInit.RUNEFORGING_SERIALIZER.get();
    }

    public IRecipeType<?> func_222127_g() {
        return RecipeInit.RUNEFORGING_TYPE;
    }

    public int getHits() {
        return this.hits;
    }

    public int getOutputQuantity() {
        return this.outputQuantity;
    }

    public ResourceLocation getMaterial() {
        return this.materialItem == null ? ItemInit.VINTEUM_INGOT_SUPERHEATED.getId() : this.materialItem;
    }

    public ResourceLocation getPatternResource() {
        return this.patternItem;
    }

    public void setPatternResource(ResourceLocation pattern) {
        this.patternItem = pattern;
    }

    public ResourceLocation getOutputResource() {
        return this.runeItem;
    }

    public void setOutputResource(ResourceLocation output) {
        this.runeItem = output;
    }

    public void setMaterial(ResourceLocation material) {
        this.materialItem = material;
    }

    public void setHits(int hits) {
        this.hits = hits;
    }

    public void setOutputQuantity(int outputQuantity) {
        this.outputQuantity = outputQuantity;
    }

    @Override
    public ItemStack getGuiRepresentationStack() {
        return this.func_77571_b();
    }
}

