/*
 * Decompiled with CFR 0.152.
 */
package com.ma.rituals;

import com.ma.api.rituals.IRitualReagent;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;

public class RitualReagent
implements IRitualReagent {
    private ResourceLocation rLoc;
    private boolean isOptional;
    private boolean shouldConsume;
    private boolean isDynamic;
    private boolean isDynamicSource;

    public RitualReagent(ResourceLocation rLoc) {
        this.rLoc = rLoc;
        this.isOptional = false;
        this.shouldConsume = true;
    }

    public RitualReagent(String namespaceID, String path) {
        this(new ResourceLocation(namespaceID, path));
    }

    public RitualReagent(String resourceName) {
        this(new ResourceLocation(resourceName));
    }

    public RitualReagent asOptional() {
        if (!this.isDynamicSource) {
            this.isOptional = true;
        }
        return this;
    }

    public RitualReagent noConsume() {
        this.shouldConsume = false;
        return this;
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return this.rLoc;
    }

    @Override
    public boolean isOptional() {
        return this.isOptional;
    }

    @Override
    public boolean shouldConsumeReagent() {
        return this.shouldConsume;
    }

    @Override
    public boolean isEmpty() {
        return this.rLoc == null || this.rLoc.toString().equals(Items.field_190931_a.getRegistryName().toString());
    }

    @Override
    public boolean isDynamic() {
        return this.isDynamic;
    }

    @Override
    public boolean isDynamicSource() {
        return this.isDynamicSource;
    }

    public RitualReagent asDynamic() {
        this.isDynamic = true;
        return this;
    }

    public RitualReagent asDynamicSource() {
        this.isOptional = false;
        this.isDynamicSource = true;
        return this;
    }

    @Override
    public void setResourceLocation(ResourceLocation rLoc) {
        if (this.isDynamic()) {
            this.rLoc = rLoc;
            this.isDynamic = false;
            this.isOptional = false;
        }
    }

    public void writeToNBT(CompoundNBT nbt) {
        if (this.rLoc == null) {
            return;
        }
        nbt.func_74778_a("ritual_reagent_resource", this.rLoc.toString());
        nbt.func_74757_a("ritual_reagent_optional", this.isOptional);
        nbt.func_74757_a("ritual_reagent_consume", this.shouldConsume);
        nbt.func_74757_a("ritual_reagent_dynamic", this.isDynamic);
        nbt.func_74757_a("ritual_reagent_dynamic_source", this.isDynamicSource);
    }

    public static RitualReagent fromNBT(CompoundNBT nbt) {
        RitualReagent rr;
        String key = "";
        if (nbt.func_74764_b("ritual_reagent_resource")) {
            key = nbt.func_74779_i("ritual_reagent_resource");
        }
        RitualReagent ritualReagent = rr = key.isEmpty() ? null : new RitualReagent(new ResourceLocation(key));
        if (nbt.func_74764_b("ritual_reagent_optional")) {
            rr.isOptional = nbt.func_74767_n("ritual_reagent_optional");
        }
        if (nbt.func_74764_b("ritual_reagent_consume")) {
            rr.shouldConsume = nbt.func_74767_n("ritual_reagent_consume");
        }
        if (nbt.func_74764_b("ritual_reagent_dynamic")) {
            rr.isDynamic = nbt.func_74767_n("ritual_reagent_dynamic");
        }
        if (nbt.func_74764_b("ritual_reagent_dynamic_source")) {
            rr.isDynamicSource = nbt.func_74767_n("ritual_reagent_dynamic_source");
        }
        return rr;
    }
}

