/*
 * Decompiled with CFR 0.152.
 */
package com.ma.rituals.effects;

import com.ma.api.rituals.IRitualContext;
import com.ma.api.rituals.RitualEffect;
import com.ma.api.spells.parts.Modifier;
import com.ma.blocks.tileentities.TileEntityChalkRune;
import com.ma.entities.utility.EntityPresentItem;
import com.ma.items.ItemInit;
import com.ma.items.sorcery.ItemModifierBook;
import com.ma.items.sorcery.ItemSpell;
import com.ma.items.sorcery.ItemSpellBook;
import com.ma.spells.crafting.SpellRecipe;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class RitualEffectAlteration
extends RitualEffect {
    public RitualEffectAlteration(ResourceLocation ritualName) {
        super(ritualName);
    }

    @Override
    public ITextComponent canRitualStart(IRitualContext context) {
        MutableBoolean canStart = new MutableBoolean(true);
        context.getAllPositions().stream().forEach(pos -> {
            SpellRecipe recipe;
            TileEntityChalkRune tecr;
            ItemStack reagentStack;
            TileEntity te = context.getWorld().func_175625_s(pos.getBlockPos());
            if (te != null && te instanceof TileEntityChalkRune && (reagentStack = (tecr = (TileEntityChalkRune)te).func_70301_a(0)).func_77973_b() instanceof ItemSpell && !(reagentStack.func_77973_b() instanceof ItemSpellBook) && (recipe = SpellRecipe.fromNBT(reagentStack.func_77978_p())).countModifiers() >= 3) {
                canStart.setFalse();
            }
        });
        if (!canStart.booleanValue()) {
            return new TranslationTextComponent("ritual.mana-and-artifice.spell_modification.at-maximum");
        }
        return super.canRitualStart(context);
    }

    @Override
    protected boolean applyRitualEffect(IRitualContext context) {
        List<ItemStack> book = context.getCollectedReagents(r -> r.func_77973_b() == ItemInit.MODIFIER_BOOK.get());
        List<ItemStack> spell = context.getCollectedReagents(r -> r.func_77973_b() == ItemInit.SPELL.get());
        if (book.size() != 1 || spell.size() != 1) {
            return false;
        }
        Optional<Modifier> m = ItemModifierBook.getModifier(book.get(0));
        SpellRecipe recipe = SpellRecipe.fromNBT(spell.get(0).func_196082_o());
        boolean didAdd = false;
        if (m.isPresent()) {
            didAdd = recipe.addModifier(m.get());
        }
        ItemStack outputStack = spell.get(0).func_77946_l();
        recipe.writeToNBT(outputStack.func_196082_o());
        EntityPresentItem epi = new EntityPresentItem(context.getWorld(), (double)context.getCenter().func_177958_n() + 0.5, context.getCenter().func_177956_o() + 1, (double)context.getCenter().func_177952_p() + 0.5, outputStack);
        context.getWorld().func_217376_c((Entity)epi);
        return didAdd;
    }

    @Override
    protected int getApplicationTicks(IRitualContext context) {
        return 0;
    }

    @Override
    protected boolean modifyRitualReagentsAndPatterns(ItemStack dataStack, IRitualContext context) {
        if (dataStack.func_77973_b() != ItemInit.MODIFIER_BOOK.get()) {
            return false;
        }
        MutableBoolean successfullyReplaced = new MutableBoolean(false);
        ItemModifierBook.getModifier(dataStack).ifPresent(m -> ItemModifierBook.getRecipe(m, context.getWorld()).ifPresent(r -> {
            context.replaceReagents(new ResourceLocation("mana-and-artifice:dynamic-modifier-1"), (NonNullList<ResourceLocation>)NonNullList.func_193580_a((Object)new ResourceLocation(""), (Object[])r.getRequiredItems()));
            context.replacePatterns((NonNullList<ResourceLocation>)NonNullList.func_193580_a((Object)new ResourceLocation(""), (Object[])r.getRequiredPatterns()));
            successfullyReplaced.setTrue();
        }));
        return successfullyReplaced.booleanValue();
    }

    @Override
    public SoundEvent getLoopSound(IRitualContext context) {
        return super.getLoopSound(context);
    }

    @Override
    public boolean spawnRitualParticles(IRitualContext context) {
        return super.spawnRitualParticles(context);
    }
}

