/*
 * Decompiled with CFR 0.152.
 */
package com.ma.rituals.effects;

import com.ma.api.rituals.IRitualContext;
import com.ma.api.rituals.RitualEffect;
import com.ma.api.sound.SFX;
import com.ma.entities.utility.EntityPresentItem;
import com.ma.events.EventDispatcher;
import com.ma.items.ItemInit;
import com.ma.spells.crafting.SpellRecipe;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;

public class RitualEffectArcana
extends RitualEffect {
    public RitualEffectArcana(ResourceLocation ritualName) {
        super(ritualName);
    }

    @Override
    protected boolean applyRitualEffect(IRitualContext context) {
        ItemStack recipeItem = ItemStack.field_190927_a;
        for (ItemStack stack : context.getCollectedReagents()) {
            if (!SpellRecipe.isReagentContainer(stack)) continue;
            recipeItem = stack;
            break;
        }
        if (recipeItem == null) {
            return false;
        }
        ItemStack spell = new ItemStack((IItemProvider)ItemInit.SPELL.get());
        SpellRecipe recipe = SpellRecipe.fromNBT(recipeItem.func_196082_o());
        recipe.setMysterious(false);
        recipe.writeToNBT(spell.func_196082_o());
        context.getWorld().func_184148_a(null, (double)context.getCenter().func_177958_n(), (double)context.getCenter().func_177956_o(), (double)context.getCenter().func_177952_p(), SFX.Event.Player.SPELL_CREATED, SoundCategory.PLAYERS, 1.0f, 1.0f);
        EntityPresentItem item = new EntityPresentItem(context.getWorld(), (float)context.getCenter().func_177984_a().func_177958_n() + 0.5f, context.getCenter().func_177984_a().func_177956_o(), (float)context.getCenter().func_177984_a().func_177952_p() + 0.5f, spell);
        context.getWorld().func_217376_c((Entity)item);
        if (recipe.isValid()) {
            EventDispatcher.DispatchSpellCrafted(recipe, context.getCaster());
        }
        return true;
    }

    @Override
    protected int getApplicationTicks(IRitualContext context) {
        return 0;
    }

    @Override
    protected boolean modifyRitualReagentsAndPatterns(ItemStack dataStack, IRitualContext context) {
        if (!SpellRecipe.isReagentContainer(dataStack)) {
            return false;
        }
        context.replaceReagents(new ResourceLocation("mana-and-artifice:dynamic-shape"), SpellRecipe.getShapeReagents(dataStack));
        context.replaceReagents(new ResourceLocation("mana-and-artifice:dynamic-component"), SpellRecipe.getComponentReagents(dataStack));
        context.replaceReagents(new ResourceLocation("mana-and-artifice:dynamic-modifier-1"), SpellRecipe.getModifierReagents(dataStack, 0));
        context.replaceReagents(new ResourceLocation("mana-and-artifice:dynamic-modifier-2"), SpellRecipe.getModifierReagents(dataStack, 1));
        context.replaceReagents(new ResourceLocation("mana-and-artifice:dynamic-modifier-3"), SpellRecipe.getModifierReagents(dataStack, 2));
        context.replaceReagents(new ResourceLocation("mana-and-artifice:dynamic-complexity"), SpellRecipe.getComplexityReagents(dataStack));
        context.replacePatterns(SpellRecipe.getPatterns(dataStack));
        return true;
    }
}

