/*
 * Decompiled with CFR 0.152.
 */
package com.ma.rituals.effects;

import com.ma.api.capabilities.Faction;
import com.ma.api.capabilities.IPlayerProgression;
import com.ma.api.rituals.IRitualContext;
import com.ma.api.rituals.RitualEffect;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.entities.EntityInit;
import com.ma.entities.rituals.EntityDemonStone;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;

public class RitualEffectBurningHells
extends RitualEffect {
    public RitualEffectBurningHells(ResourceLocation ritualName) {
        super(ritualName);
    }

    @Override
    public ITextComponent canRitualStart(IRitualContext context) {
        IPlayerProgression progression = (IPlayerProgression)context.getCaster().getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        if (progression == null) {
            return new StringTextComponent("Progression could not be found...this is a problem.");
        }
        if (progression.getTier() > 2 && progression.getAlliedFaction() != Faction.DEMONS) {
            return new TranslationTextComponent("ritual.mana-and-artifice.progression.wrong_faction");
        }
        if (progression.getTierProgress() < 1.0f) {
            return new TranslationTextComponent("ritual.mana-and-artifice.progression.not_ready");
        }
        return null;
    }

    @Override
    protected boolean applyRitualEffect(IRitualContext context) {
        IPlayerProgression progression = (IPlayerProgression)context.getCaster().getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        if (progression != null && progression.hasAlliedFaction() && progression.getAlliedFaction() != Faction.DEMONS) {
            context.getCaster().func_145747_a((ITextComponent)new TranslationTextComponent("event.mana-and-artifice.faction_ritual_failed"), Util.field_240973_b_);
            return false;
        }
        BlockPos pos = context.getCenter();
        if (context.getCaster() == null || context.getCaster().func_110124_au() == null) {
            return false;
        }
        EntityDemonStone e = (EntityDemonStone)((EntityType)EntityInit.DEMON_STONE.get()).func_220331_a((ServerWorld)context.getWorld(), null, context.getCaster(), pos, SpawnReason.EVENT, false, false);
        e.func_70012_b((float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f, 0.0f, 0.0f);
        e.setCasterUUID(context.getCaster().func_110124_au());
        return true;
    }

    @Override
    protected int getApplicationTicks(IRitualContext context) {
        return 200;
    }
}

