/*
 * Decompiled with CFR 0.152.
 */
package com.ma.rituals.effects;

import com.ma.api.rituals.IRitualContext;
import com.ma.api.sound.SFX;
import com.ma.items.ItemInit;
import com.ma.rituals.effects.RitualEffectCreateEssence;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.biome.Biome;

public class RitualEffectDeepOcean
extends RitualEffectCreateEssence {
    public RitualEffectDeepOcean(ResourceLocation ritualName) {
        super(ritualName, new ItemStack((IItemProvider)ItemInit.ENCHANTMENT_FOCUS_WATER.get()));
    }

    @Override
    public ITextComponent canRitualStart(IRitualContext context) {
        Biome centerBiome = context.getWorld().func_226691_t_(context.getCenter());
        if (centerBiome.func_201856_r() != Biome.Category.OCEAN) {
            return new TranslationTextComponent("ritual.mana-and-artifice.deep_ocean.not_ocean");
        }
        return null;
    }

    @Override
    public SoundEvent getLoopSound(IRitualContext context) {
        return SFX.Loops.WATER;
    }

    @Override
    public boolean spawnRitualParticles(IRitualContext context) {
        Vector3d center = new Vector3d((double)context.getCenter().func_177958_n() + 0.5, (double)(context.getCenter().func_177956_o() + 3), (double)context.getCenter().func_177952_p() + 0.5);
        double radius = context.getRecipe().getLowerBound();
        for (int i = 0; i < 40; ++i) {
            context.getWorld().func_195594_a((IParticleData)ParticleTypes.field_218425_n, center.field_72450_a - radius + Math.random() * radius * 2.0, center.field_72448_b, center.field_72449_c - radius + Math.random() * radius * 2.0, 0.0, 0.0, 0.0);
        }
        return true;
    }
}

