/*
 * Decompiled with CFR 0.152.
 */
package com.ma.rituals.effects;

import com.ma.api.particles.ParticleInit;
import com.ma.api.rituals.IRitualContext;
import com.ma.api.sound.SFX;
import com.ma.blocks.BlockInit;
import com.ma.blocks.ritual.BlockChalkRune;
import com.ma.items.ItemInit;
import com.ma.rituals.effects.RitualEffectCreateEssence;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class RitualEffectEndlessVoid
extends RitualEffectCreateEssence {
    public RitualEffectEndlessVoid(ResourceLocation ritualName) {
        super(ritualName, new ItemStack((IItemProvider)ItemInit.ENCHANTMENT_FOCUS_ENDER.get()));
    }

    @Override
    public ITextComponent canRitualStart(IRitualContext context) {
        BlockState state = context.getWorld().func_180495_p(context.getCenter());
        boolean semiActiveRitual = (Boolean)state.func_177229_b((Property)BlockChalkRune.ACTIVATED) == true;
        for (int i = 0; i < context.getRecipe().getLowerBound(); ++i) {
            for (int j = 0; j < context.getRecipe().getLowerBound(); ++j) {
                int lightLevel = context.getWorld().func_201696_r(context.getCenter().func_177982_a(-i, 0, j));
                if (semiActiveRitual) {
                    lightLevel -= 6;
                }
                if (lightLevel <= 0) continue;
                context.getWorld().func_175656_a(context.getCenter().func_177982_a(-i, 0, j), ((Block)BlockInit.MAGE_LIGHT.get()).func_176223_P());
                return new TranslationTextComponent("ritual.mana-and-artifice.endless_void.too_bright");
            }
        }
        return null;
    }

    @Override
    public SoundEvent getLoopSound(IRitualContext context) {
        return SFX.Loops.ENDER;
    }

    @Override
    public boolean spawnRitualParticles(IRitualContext context) {
        Vector3d center = new Vector3d((double)context.getCenter().func_177958_n() + 0.5, (double)context.getCenter().func_177956_o() + 0.1, (double)context.getCenter().func_177952_p() + 0.5);
        double radius = context.getRecipe().getLowerBound();
        for (float i = 0.0f; i < 360.0f; i += 15.0f) {
            double angleR = Math.toRadians(i);
            double offsetX = Math.cos(angleR) * radius;
            double offsetZ = Math.sin(angleR) * radius;
            Vector3d start = center.func_72441_c(offsetX, 0.0, offsetZ);
            context.getWorld().func_195594_a((IParticleData)ParticleInit.ENDER.get(), start.field_72450_a, start.field_72448_b, start.field_72449_c, center.field_72450_a, center.field_72448_b, center.field_72449_c);
        }
        return true;
    }
}

