/*
 * Decompiled with CFR 0.152.
 */
package com.ma.rituals.effects;

import com.ma.api.rituals.IRitualContext;
import com.ma.api.rituals.RitualEffect;
import com.ma.entities.EntityInit;
import com.ma.entities.rituals.EntityFlatLands;
import com.ma.items.ItemInit;
import com.ma.items.runes.ItemRuneMarking;
import com.ma.tools.math.MathUtilities;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;

public class RitualEffectFlatLands
extends RitualEffect {
    public static final int MAX_DISTANCE = 80;

    public RitualEffectFlatLands(ResourceLocation ritualName) {
        super(ritualName);
    }

    @Override
    protected boolean applyRitualEffect(IRitualContext context) {
        ItemStack location_rune_a = ItemStack.field_190927_a;
        ItemStack location_rune_b = ItemStack.field_190927_a;
        for (ItemStack stack : context.getCollectedReagents(i -> i.func_77973_b() == ItemInit.RUNE_MARKING.get())) {
            if (location_rune_a.func_190926_b()) {
                location_rune_a = stack;
                continue;
            }
            location_rune_b = stack;
            break;
        }
        if (location_rune_a.func_190926_b() || location_rune_b.func_190926_b()) {
            return false;
        }
        BlockPos location_a = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getLocation(location_rune_a);
        BlockPos location_b = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getLocation(location_rune_b);
        if (location_a == null || location_b == null) {
            return false;
        }
        if (!location_a.func_218141_a((Vector3i)context.getCenter(), 80.0) && !location_b.func_218141_a((Vector3i)context.getCenter(), 80.0)) {
            context.getCaster().func_145747_a((ITextComponent)new TranslationTextComponent("mana-and-artifice:rituals/flat_lands.tooFar"), Util.field_240973_b_);
            return false;
        }
        AxisAlignedBB bb = MathUtilities.createInclusiveBB(location_a, location_b);
        if (bb.func_216364_b() > 80.0 || bb.func_216360_c() > 80.0 || bb.func_216362_d() > 80.0) {
            context.getCaster().func_145747_a((ITextComponent)new TranslationTextComponent("mana-and-artifice:rituals/flat_lands.tooBig"), Util.field_240973_b_);
            return false;
        }
        EntityFlatLands flat_lands = (EntityFlatLands)((EntityType)EntityInit.FLAT_LANDS.get()).func_220331_a((ServerWorld)context.getWorld(), null, null, context.getCenter().func_177981_b(2), SpawnReason.EVENT, true, true);
        flat_lands.setCaster(context.getCaster());
        flat_lands.setBounds(bb);
        return true;
    }

    @Override
    protected int getApplicationTicks(IRitualContext context) {
        return 0;
    }
}

