/*
 * Decompiled with CFR 0.152.
 */
package com.ma.rituals.effects;

import com.ma.api.capabilities.IRitualTeleportLocation;
import com.ma.api.capabilities.IWorldMagic;
import com.ma.api.rituals.IRitualContext;
import com.ma.api.rituals.RitualEffect;
import com.ma.capabilities.worlddata.WorldMagicProvider;
import com.ma.entities.EntityInit;
import com.ma.entities.rituals.EntityPortal;
import com.ma.items.ritual.ItemWorldCharm;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.mutable.MutableObject;

public class RitualEffectGate
extends RitualEffect {
    public RitualEffectGate(ResourceLocation ritualName) {
        super(ritualName);
    }

    @Override
    protected boolean applyRitualEffect(IRitualContext context) {
        List<ItemStack> reagents = context.getCollectedReagents();
        if (reagents.size() == 11 && !context.getWorld().field_72995_K) {
            MinecraftServer server;
            RegistryKey worldKey;
            ItemStack reagentNine = reagents.get(9);
            RegistryKey registryKey = worldKey = !reagentNine.func_190926_b() && reagentNine.func_77973_b() instanceof ItemWorldCharm ? ((ItemWorldCharm)reagentNine.func_77973_b()).GetWorldTarget(reagentNine) : context.getWorld().func_234923_W_();
            if (worldKey == null) {
                worldKey = context.getWorld().func_234923_W_();
            }
            if ((server = ((ServerWorld)context.getWorld()).func_73046_m()) == null) {
                return false;
            }
            String worldKeyString = worldKey.toString();
            MutableObject targetWorld = new MutableObject(null);
            server.func_212370_w().iterator().forEachRemaining(sw -> {
                if (sw == null) {
                    return;
                }
                if (worldKeyString.equals(sw.func_234923_W_().toString())) {
                    targetWorld.setValue(sw);
                }
            });
            if (targetWorld == null || targetWorld.getValue() == null) {
                context.getCaster().func_145747_a((ITextComponent)new TranslationTextComponent("mana-and-artifice:rituals/return.world_not_found"), Util.field_240973_b_);
                return false;
            }
            LazyOptional worldMagicContainer = ((ServerWorld)targetWorld.getValue()).getCapability(WorldMagicProvider.MAGIC);
            if (worldMagicContainer.isPresent()) {
                IWorldMagic worldMagic = (IWorldMagic)worldMagicContainer.orElse(null);
                DyeColor portalColor = !reagents.get(8).func_190926_b() && reagents.get(8).func_77973_b() instanceof DyeItem ? ((DyeItem)reagents.get(8).func_77973_b()).func_195962_g() : null;
                ArrayList<ResourceLocation> runes = new ArrayList<ResourceLocation>();
                for (int i = 0; i < 8; ++i) {
                    runes.add(reagents.get(i).func_77973_b().getRegistryName());
                }
                IRitualTeleportLocation teleportTarget = worldMagic.getRitualTeleportBlockLocation(runes, (RegistryKey<World>)worldKey);
                if (teleportTarget == null) {
                    context.getCaster().func_145747_a((ITextComponent)new TranslationTextComponent("mana-and-artifice:rituals/return.not_found"), Util.field_240973_b_);
                    return false;
                }
                Entity portal = ((EntityType)EntityInit.PORTAL_ENTITY.get()).func_220331_a((ServerWorld)context.getWorld(), null, null, context.getCenter().func_177984_a(), SpawnReason.TRIGGERED, true, false);
                if (portal != null && portal instanceof EntityPortal) {
                    ((EntityPortal)portal).setTeleportBlockPos(teleportTarget.getPos().func_177984_a(), teleportTarget.getWorldType());
                    ((EntityPortal)portal).setPermanent();
                    if (portalColor != null) {
                        ((EntityPortal)portal).setDyeColor(portalColor);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected int getApplicationTicks(IRitualContext context) {
        return 20;
    }
}

