/*
 * Decompiled with CFR 0.152.
 */
package com.ma.rituals.effects;

import com.ma.ManaAndArtifice;
import com.ma.api.rituals.IRitualContext;
import com.ma.api.rituals.RitualEffect;
import com.ma.entities.utility.EntityPresentItem;
import com.ma.items.ItemInit;
import com.ma.items.ritual.ItemThaumaturgicLink;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Logger;

public class RitualEffectLocate
extends RitualEffect {
    public RitualEffectLocate(ResourceLocation ritualName) {
        super(ritualName);
    }

    @Override
    protected boolean applyRitualEffect(IRitualContext context) {
        Optional thaumLinkOptional = context.getCollectedReagents(i -> i.func_77973_b() == ItemInit.THAUMATURGIC_LINK.get()).stream().findFirst();
        if (!thaumLinkOptional.isPresent()) {
            return false;
        }
        ItemStack outputCompass = new ItemStack((IItemProvider)ItemInit.THAUMATURGIC_COMPASS.get());
        ItemStack thaumLink = (ItemStack)thaumLinkOptional.get();
        BlockPos targetPos = this.locateStructure((ServerWorld)context.getWorld(), context.getCenter(), thaumLink);
        if (targetPos == null && (targetPos = this.locateBiome((ServerWorld)context.getWorld(), context.getCenter(), thaumLink)) == null) {
            context.getCollectedReagents().forEach(i -> {
                ItemEntity item = new ItemEntity(context.getWorld(), (double)context.getCenter().func_177958_n(), (double)context.getCenter().func_177984_a().func_177956_o(), (double)context.getCenter().func_177952_p(), i);
                context.getWorld().func_217376_c((Entity)item);
            });
            return false;
        }
        this.setCompassTrackingLocation((RegistryKey<World>)context.getWorld().func_234923_W_(), targetPos, outputCompass.func_196082_o());
        context.getWorld().func_184133_a((PlayerEntity)null, context.getCenter(), SoundEvents.field_232731_hu_, SoundCategory.PLAYERS, 1.0f, 1.0f);
        outputCompass.func_196082_o().func_74778_a("tracking_type", ((ItemThaumaturgicLink)ItemInit.THAUMATURGIC_LINK.get()).getLocationKey(thaumLink, context.getWorld()).toString());
        EntityPresentItem epi = new EntityPresentItem(context.getWorld(), context.getCenter().func_177958_n(), context.getCenter().func_177984_a().func_177956_o(), context.getCenter().func_177952_p(), outputCompass);
        context.getWorld().func_217376_c((Entity)epi);
        return false;
    }

    @Nullable
    private BlockPos locateBiome(ServerWorld world, BlockPos center, ItemStack thaumLink) {
        ResourceLocation biomeLoc = ((ItemThaumaturgicLink)ItemInit.THAUMATURGIC_LINK.get()).getLocationKey(thaumLink, (World)world);
        if (biomeLoc == null) {
            return null;
        }
        Optional biome = world.func_73046_m().func_244267_aX().func_243612_b(Registry.field_239720_u_).func_241873_b(biomeLoc);
        if (!biome.isPresent()) {
            return null;
        }
        return world.func_241116_a_((Biome)biome.get(), center, 6400, 8);
    }

    @Nullable
    private BlockPos locateStructure(ServerWorld world, BlockPos center, ItemStack thaumLink) {
        ResourceLocation structureLoc = ((ItemThaumaturgicLink)ItemInit.THAUMATURGIC_LINK.get()).getLocationKey(thaumLink, (World)world);
        if (structureLoc == null) {
            return null;
        }
        Structure structure = (Structure)ForgeRegistries.STRUCTURE_FEATURES.getValue(structureLoc);
        if (structure == null) {
            return null;
        }
        return world.func_241117_a_(structure, center, 100, false);
    }

    @Override
    protected int getApplicationTicks(IRitualContext context) {
        return 0;
    }

    private void setCompassTrackingLocation(RegistryKey<World> dimension, BlockPos position, CompoundNBT compassData) {
        compassData.func_218657_a("LodestonePos", (INBT)NBTUtil.func_186859_a((BlockPos)position));
        World.field_234917_f_.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, dimension).resultOrPartial(arg_0 -> ((Logger)ManaAndArtifice.LOGGER).error(arg_0)).ifPresent(inbt -> compassData.func_218657_a("LodestoneDimension", inbt));
        compassData.func_74757_a("LodestoneTracked", true);
    }
}

