/*
 * Decompiled with CFR 0.152.
 */
package com.ma.rituals.effects;

import com.ma.api.rituals.IRitualContext;
import com.ma.entities.utility.EntityPresentItem;
import com.ma.events.delayed.DelayedEventQueue;
import com.ma.events.delayed.TimedDelayedEvent;
import com.ma.items.ItemInit;
import com.ma.rituals.effects.RitualEffectHole;
import com.ma.tools.BlockUtils;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.ToolType;

public class RitualEffectStaircase
extends RitualEffectHole {
    public RitualEffectStaircase(ResourceLocation ritualName) {
        super(ritualName);
    }

    @Override
    protected boolean applyRitualEffect(IRitualContext context) {
        int delay = 10;
        BlockPos pos = context.getCenter().func_177977_b();
        Direction dir = context.getRecipe().getMatchedDirection(context.getWorld(), context.getCenter());
        if (dir == Direction.SOUTH || dir == Direction.NORTH) {
            dir = dir.func_176734_d();
        }
        while (pos.func_177956_o() > 10 && context.getWorld().func_180495_p(pos).func_177230_c() != Blocks.field_150357_h) {
            DelayedEventQueue.pushEvent(context.getWorld(), new TimedDelayedEvent<RitualEffectHole.DelayData>("staircase", delay, new RitualEffectHole.DelayData(context.getCaster(), pos, context.getWorld()), this::breakBlocks));
            delay += 10;
            pos = pos.func_177977_b().func_177971_a(dir.func_176730_m());
        }
        EntityPresentItem epi = new EntityPresentItem(context.getWorld(), context.getCenter().func_177958_n(), context.getCenter().func_177956_o() + 1, context.getCenter().func_177952_p());
        epi.func_92058_a(new ItemStack((IItemProvider)ItemInit.FLAT_LANDS_BOOK.get()));
        epi.func_70016_h(0.0, 0.0, 0.0);
        context.getWorld().func_217376_c((Entity)epi);
        return true;
    }

    private void breakBlocks(String identifier, RitualEffectHole.DelayData data) {
        if (data.caster == null || data.world == null || !data.world.func_195588_v(data.center)) {
            return;
        }
        for (int i = -1; i <= 1; ++i) {
            for (int j = 0; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    BlockPos target = data.center.func_177982_a(i, j, k);
                    if (!data.world.func_195588_v(target) || data.world.func_175625_s(target) != null) continue;
                    BlockUtils.destroyBlock((LivingEntity)data.caster, data.world, target, false, 2, ToolType.SHOVEL, ToolType.PICKAXE);
                }
            }
        }
    }
}

