/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells;

import com.ma.spells.crafting.SpellRecipe;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;

public class SpellAdjuster {
    private final Function<SpellAdjustingContext, Boolean> executeCheck;
    private final BiConsumer<SpellRecipe, PlayerEntity> adjuster;

    public SpellAdjuster(Function<SpellAdjustingContext, Boolean> executeCheck, BiConsumer<SpellRecipe, PlayerEntity> adjuster) {
        this.executeCheck = executeCheck;
        this.adjuster = adjuster;
    }

    public boolean check(SpellCastStage stage, ItemStack stack, @Nullable PlayerEntity caster) {
        return this.executeCheck.apply(new SpellAdjustingContext(stack, caster, stage));
    }

    public void modify(SpellRecipe recipe, @Nullable PlayerEntity caster) {
        this.adjuster.accept(recipe, caster);
    }

    public static class SpellAdjustingContext {
        public final ItemStack stack;
        public final PlayerEntity caster;
        public final SpellCastStage stage;

        public SpellAdjustingContext(ItemStack stack, PlayerEntity caster, SpellCastStage stage) {
            this.stack = stack;
            this.caster = caster;
            this.stage = stage;
        }
    }

    public static enum SpellCastStage {
        SPELL_TOOLTIP,
        SPELLCRAFTING_MANA_COST_ESTIMATE,
        CALCULATING_MANA_COST,
        CASTING;

    }
}

