/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells;

import com.ma.api.affinity.Affinity;
import com.ma.api.capabilities.IPlayerMagic;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.parts.Component;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.interop.CuriosInterop;
import com.ma.items.IHellfireItem;
import com.ma.items.ItemInit;
import com.ma.items.sorcery.ItemSpell;
import com.ma.spells.SpellAdjuster;
import com.ma.spells.SpellsInit;
import com.ma.spells.crafting.SpellRecipe;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotTypePreset;

public final class SpellAdjusters {
    private static final float AFFINITY_MANA_COST_FACTOR = 0.5f;

    public static final boolean adjustAlways(SpellAdjuster.SpellAdjustingContext context) {
        return true;
    }

    public static final boolean adjustOnToolTipAndCastOnly(SpellAdjuster.SpellAdjustingContext context) {
        return context.stage == SpellAdjuster.SpellCastStage.CASTING || context.stage == SpellAdjuster.SpellCastStage.SPELL_TOOLTIP;
    }

    public static final void modifyBasedOnAffinity(SpellRecipe recipe, @Nullable PlayerEntity caster) {
        if (caster == null) {
            return;
        }
        LazyOptional magicContainer = caster.getCapability(PlayerMagicProvider.MAGIC);
        if (!magicContainer.isPresent()) {
            return;
        }
        IPlayerMagic magic = (IPlayerMagic)magicContainer.orElse(null);
        if (magic == null) {
            return;
        }
        float base_mana_cost = recipe.getManaCost();
        float modification_reduce = 0.0f;
        float modification_increase = 0.0f;
        HashMap<Affinity, Float> affList = recipe.getAffinity();
        for (Affinity affinity : affList.keySet()) {
            modification_reduce += magic.getAffinityDepth(affinity) * 0.5f / 100.0f * affList.get((Object)affinity).floatValue();
            modification_increase += magic.getAffinityDepth(affinity.getOpposite()) * 0.5f / 100.0f * affList.get((Object)affinity).floatValue();
        }
        recipe.setManaCost(base_mana_cost - base_mana_cost * modification_reduce + base_mana_cost * modification_increase);
    }

    public static final void modifyChanneled(SpellRecipe recipe, @Nullable PlayerEntity caster) {
        if (recipe.isChanneled()) {
            float manaCostPerTick = recipe.getManaCost() / 20.0f;
            recipe.setManaCost(manaCostPerTick * 0.5f);
        }
    }

    public static final boolean checkHellfireStaff(SpellAdjuster.SpellAdjustingContext context) {
        return context.stack.func_77973_b() instanceof IHellfireItem;
    }

    public static final void modifyHellfireStaff(SpellRecipe recipe, @Nullable PlayerEntity caster) {
        if (recipe.getAffinity().containsKey((Object)Affinity.FIRE)) {
            recipe.iterateComponents(c -> {
                if (((Component)c.getPart()).getAffinity() == Affinity.FIRE) {
                    for (Attribute attr : c.getContainedAttributes()) {
                        c.setValue(attr, c.getValue(attr) * 2.0f);
                    }
                }
            });
            recipe.setOverrideAffinity(Affinity.HELLFIRE);
            recipe.setManaCost(recipe.getManaCost() * 3.0f);
        }
    }

    public static final boolean checkArcaneCrown(SpellAdjuster.SpellAdjustingContext context) {
        if (context.caster == null) {
            return false;
        }
        return ((ItemStack)context.caster.field_71071_by.field_70460_b.get(EquipmentSlotType.HEAD.func_188454_b())).func_77973_b() == ItemInit.ARCANE_CROWN.get() || CuriosInterop.IsItemInCurioSlot((Item)ItemInit.ARCANE_CROWN.get(), (LivingEntity)context.caster, SlotTypePreset.HEAD);
    }

    public static final void modifyArcaneCrown(SpellRecipe recipe, @Nullable PlayerEntity caster) {
        recipe.setManaCost(recipe.getManaCost() * 0.85f);
    }

    public static final void modifyBreakRings(SpellRecipe recipe, @Nullable PlayerEntity caster) {
        if (caster == null) {
            return;
        }
        recipe.getComponents().stream().filter(c -> c.getPart() == SpellsInit.BREAK).findFirst().ifPresent(c -> {
            int magnitudeIncrease = 0;
            if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemInit.BREAK_RING_GREATER.get(), (LivingEntity)caster).isPresent()) {
                magnitudeIncrease = 2;
            } else if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemInit.BREAK_RING_LESSER.get(), (LivingEntity)caster).isPresent()) {
                magnitudeIncrease = 1;
            }
            for (int i = 0; i < magnitudeIncrease; ++i) {
                c.stepUp(Attribute.MAGNITUDE);
            }
        });
    }

    public static final void modifyBattlemageAmulet(SpellRecipe recipe, @Nullable PlayerEntity caster) {
        if (caster == null) {
            return;
        }
        if (!CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemInit.BATTLEMAGE_AMULET.get(), (LivingEntity)caster).isPresent()) {
            return;
        }
        ItemStack mainHand = caster.func_184614_ca();
        ItemStack offHand = caster.func_184592_cb();
        if (mainHand.func_77973_b() instanceof SwordItem && offHand.func_77973_b() instanceof ItemSpell || offHand.func_77973_b() instanceof SwordItem && mainHand.func_77973_b() instanceof ItemSpell) {
            recipe.getComponents().forEach(c -> c.setMultiplier(Attribute.DAMAGE, c.getMultiplier(Attribute.DAMAGE) + 0.1f));
        }
    }
}

