/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.components;

import com.ma.api.affinity.Affinity;
import com.ma.api.capabilities.IPlayerMagic;
import com.ma.api.particles.ParticleInit;
import com.ma.api.spells.ComponentApplicationResult;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.items.ItemInit;
import com.ma.items.artifice.SpellModifierRing;
import com.ma.tools.TeleportHelper;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import top.theillusivec4.curios.api.CuriosApi;

public class ComponentBlink
extends Component {
    public ComponentBlink(ResourceLocation registryName, ResourceLocation guiIcon) {
        super(registryName, guiIcon, new AttributeValuePair(Attribute.RANGE, 5.0f, 5.0f, 16.0f, 1.0f, 2.0f));
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<Component> modificationData, SpellContext context) {
        if (target == SpellTarget.NONE) {
            return ComponentApplicationResult.FAIL;
        }
        Vector3d targetPosition = null;
        LivingEntity tgt = null;
        if (target.isLivingEntity()) {
            tgt = target.getLivingEntity();
            targetPosition = this.calculateBlinkPosition(modificationData, tgt, (World)context.getWorld());
        } else if (target.isBlock()) {
            if (source.hasCasterReference() && source.isPlayerCaster() && ((SpellModifierRing)ItemInit.BLINK_PRECISION_RING.get()).isEquippedAndHasMana(source.getCaster(), 1.0f, false)) {
                tgt = source.getCaster();
                BlockPos check = target.getBlock().func_177984_a();
                if (this.CheckCoords((World)context.getWorld(), check.func_177958_n(), check.func_177956_o(), check.func_177952_p()) && (targetPosition = target.getPosition().func_72441_c(0.0, 1.0, 0.0)).func_72438_d(tgt.func_213303_ch()) > (double)(modificationData.getValue(Attribute.RANGE) * 2.0f)) {
                    if (tgt instanceof PlayerEntity) {
                        ((PlayerEntity)tgt).func_145747_a((ITextComponent)new TranslationTextComponent("mana-and-artifice:components/blink.toofar"), Util.field_240973_b_);
                    }
                    return ComponentApplicationResult.FAIL;
                }
                if (source.isPlayerCaster()) {
                    CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemInit.BLINK_PRECISION_RING.get(), source.getCaster()).ifPresent(t -> ((SpellModifierRing)ItemInit.BLINK_PRECISION_RING.get()).consumeMana((ItemStack)t.getRight(), 1.0f, source.getPlayer()));
                }
            }
        } else {
            return ComponentApplicationResult.FAIL;
        }
        if (tgt == source.getCaster() && source.isPlayerCaster()) {
            IPlayerMagic magic = (IPlayerMagic)source.getPlayer().getCapability(PlayerMagicProvider.MAGIC).orElse(null);
            if (magic == null || magic.getAirCasts() >= magic.getAirCastLimit(source.getPlayer())) {
                return ComponentApplicationResult.FAIL;
            }
            if (!source.getPlayer().func_233570_aj_()) {
                magic.incrementAirCasts(source.getPlayer());
            }
        }
        if (!context.getWorld().func_201670_d() && tgt != null) {
            if (targetPosition == null) {
                if (tgt instanceof PlayerEntity) {
                    ((PlayerEntity)tgt).func_145747_a((ITextComponent)new TranslationTextComponent("mana-and-artifice:components/blink.failed"), Util.field_240973_b_);
                }
                return ComponentApplicationResult.FAIL;
            }
            TeleportHelper.teleportEntity((Entity)tgt, (RegistryKey<World>)context.getWorld().func_234923_W_(), targetPosition);
            return ComponentApplicationResult.SUCCESS;
        }
        return ComponentApplicationResult.FAIL;
    }

    private Vector3d calculateBlinkPosition(IModifiedSpellPart<Component> modificationData, LivingEntity tgt, World world) {
        double distance = modificationData.getValue(Attribute.RANGE);
        double motionX = (double)(-MathHelper.func_76126_a((float)(tgt.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(tgt.field_70125_A / 180.0f * 3.141593f))) * distance;
        double motionZ = (double)(MathHelper.func_76134_b((float)(tgt.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(tgt.field_70125_A / 180.0f * 3.141593f))) * distance;
        double motionY = (double)(-MathHelper.func_76126_a((float)(tgt.field_70125_A / 180.0f * 3.141593f))) * distance;
        double d = motionX;
        double d1 = motionY;
        double d2 = motionZ;
        float f2 = MathHelper.func_76133_a((double)(d * d + d1 * d1 + d2 * d2));
        d /= (double)f2;
        d1 /= (double)f2;
        d2 /= (double)f2;
        motionX = d *= distance;
        motionY = d1 *= distance;
        motionZ = d2 *= distance;
        double newX = tgt.func_226277_ct_() + motionX;
        double newZ = tgt.func_226281_cx_() + motionZ;
        double newY = tgt.func_226278_cu_() + motionY;
        boolean coordsValid = false;
        while (!coordsValid && distance > 0.0) {
            motionX = (double)(-MathHelper.func_76126_a((float)(tgt.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(tgt.field_70125_A / 180.0f * 3.141593f))) * distance;
            motionZ = (double)(MathHelper.func_76134_b((float)(tgt.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(tgt.field_70125_A / 180.0f * 3.141593f))) * distance;
            motionY = (double)(-MathHelper.func_76126_a((float)(tgt.field_70125_A / 180.0f * 3.141593f))) * distance;
            d = motionX;
            d1 = motionY;
            d2 = motionZ;
            f2 = MathHelper.func_76133_a((double)(d * d + d1 * d1 + d2 * d2));
            d /= (double)f2;
            d1 /= (double)f2;
            d2 /= (double)f2;
            motionX = d *= distance;
            motionY = d1 *= distance;
            motionZ = d2 *= distance;
            newX = tgt.func_226277_ct_() + motionX;
            newZ = tgt.func_226281_cx_() + motionZ;
            newY = tgt.func_226278_cu_() + motionY;
            if (distance < 0.0) {
                coordsValid = false;
                break;
            }
            if (this.CheckCoords(world, (int)Math.floor(newX), (int)newY, (int)Math.floor(newZ))) {
                newX = Math.floor(newX) + 0.5;
                newZ = Math.floor(newZ) + 0.5;
                coordsValid = true;
                break;
            }
            if (this.CheckCoords(world, (int)Math.floor(newX), (int)newY, (int)Math.ceil(newZ))) {
                newX = Math.floor(newX) + 0.5;
                newZ = Math.ceil(newZ) + 0.5;
                coordsValid = true;
                break;
            }
            if (this.CheckCoords(world, (int)Math.ceil(newX), (int)newY, (int)Math.floor(newZ))) {
                newX = Math.ceil(newX) + 0.5;
                newZ = Math.floor(newZ) + 0.5;
                coordsValid = true;
                break;
            }
            if (this.CheckCoords(world, (int)Math.ceil(newX), (int)newY, (int)Math.ceil(newZ))) {
                newX = Math.ceil(newX) + 0.5;
                newZ = Math.ceil(newZ) + 0.5;
                coordsValid = true;
                break;
            }
            if (this.CheckCoords(world, (int)Math.floor(newX), (int)newY - 1, (int)Math.floor(newZ))) {
                newX = Math.floor(newX) + 0.5;
                newZ = Math.floor(newZ) + 0.5;
                newY -= 1.0;
                coordsValid = true;
                break;
            }
            if (this.CheckCoords(world, (int)Math.floor(newX), (int)newY - 1, (int)Math.ceil(newZ))) {
                newX = Math.floor(newX) + 0.5;
                newZ = Math.ceil(newZ) + 0.5;
                newY -= 1.0;
                coordsValid = true;
                break;
            }
            if (this.CheckCoords(world, (int)Math.ceil(newX), (int)newY - 1, (int)Math.floor(newZ))) {
                newX = Math.ceil(newX) + 0.5;
                newZ = Math.floor(newZ) + 0.5;
                newY -= 1.0;
                coordsValid = true;
                break;
            }
            if (this.CheckCoords(world, (int)Math.ceil(newX), (int)newY - 1, (int)Math.ceil(newZ))) {
                newX = Math.ceil(newX) + 0.5;
                newZ = Math.ceil(newZ) + 0.5;
                newY -= 1.0;
                coordsValid = true;
                break;
            }
            if (this.CheckCoords(world, (int)Math.floor(newX), (int)newY + 1, (int)Math.floor(newZ))) {
                newX = Math.floor(newX) + 0.5;
                newZ = Math.floor(newZ) + 0.5;
                newY += 1.0;
                coordsValid = true;
                break;
            }
            if (this.CheckCoords(world, (int)Math.floor(newX), (int)newY + 1, (int)Math.ceil(newZ))) {
                newX = Math.floor(newX) + 0.5;
                newZ = Math.ceil(newZ) + 0.5;
                newY += 1.0;
                coordsValid = true;
                break;
            }
            if (this.CheckCoords(world, (int)Math.ceil(newX), (int)newY + 1, (int)Math.floor(newZ))) {
                newX = Math.ceil(newX) + 0.5;
                newZ = Math.floor(newZ) + 0.5;
                newY += 1.0;
                coordsValid = true;
                break;
            }
            if (this.CheckCoords(world, (int)Math.ceil(newX), (int)newY + 1, (int)Math.ceil(newZ))) {
                newX = Math.ceil(newX) + 0.5;
                newZ = Math.ceil(newZ) + 0.5;
                newY += 1.0;
                coordsValid = true;
                break;
            }
            motionX = (double)(-MathHelper.func_76126_a((float)(tgt.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(tgt.field_70125_A / 180.0f * 3.141593f))) * (distance -= 1.0);
            motionZ = (double)(MathHelper.func_76134_b((float)(tgt.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(tgt.field_70125_A / 180.0f * 3.141593f))) * distance;
            motionY = (double)(-MathHelper.func_76126_a((float)(tgt.field_70125_A / 180.0f * 3.141593f))) * distance;
            d = motionX;
            d1 = motionY;
            d2 = motionZ;
            f2 = MathHelper.func_76133_a((double)(d * d + d1 * d1 + d2 * d2));
            d /= (double)f2;
            d1 /= (double)f2;
            d2 /= (double)f2;
            motionX = d *= distance;
            motionY = d1 *= distance;
            motionZ = d2 *= distance;
            newX = tgt.func_226277_ct_() + motionX;
            newZ = tgt.func_226281_cx_() + motionZ;
            newY = tgt.func_226278_cu_() + motionY;
        }
        if (coordsValid) {
            return new Vector3d(newX, newY, newZ);
        }
        return null;
    }

    private boolean CheckCoords(World world, int x, int y, int z) {
        if (y < 0) {
            return false;
        }
        BlockPos pos = new BlockPos(x, y, z);
        BlockState state = world.func_180495_p(pos);
        BlockState up = world.func_180495_p(pos.func_177984_a());
        return !state.func_200132_m() && !up.func_200132_m();
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.ENDER;
    }

    @Override
    public void SpawnParticles(World world, Vector3d impact_position, int age, PlayerEntity caster, ISpellDefinition recipe) {
        if (age == 0) {
            float particle_spread = 1.0f;
            float v = 1.0f;
            int particleCount = 25;
            for (int i = 0; i < particleCount; ++i) {
                Vector3d velocity = new Vector3d(0.0, Math.random() * (double)v, 0.0);
                world.func_195594_a((IParticleData)ParticleInit.ENDER_VELOCITY.get(), impact_position.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), impact_position.field_72448_b + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), impact_position.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
            }
        }
    }

    @Override
    public float initialComplexity() {
        return 10.0f;
    }

    @Override
    public int requiredXPForRote() {
        return 300;
    }
}

