/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.components;

import com.ma.api.affinity.Affinity;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.api.spells.ComponentApplicationResult;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.items.ItemInit;
import com.ma.items.artifice.SpellModifierRing;
import com.ma.items.runes.ItemRuneMarking;
import com.ma.tools.BlockUtils;
import com.ma.tools.InventoryUtilities;
import java.util.ArrayList;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import top.theillusivec4.curios.api.CuriosApi;

public class ComponentBreak
extends Component {
    private ToolType[] emulatedTools = new ToolType[]{ToolType.AXE, ToolType.PICKAXE, ToolType.SHOVEL, ToolType.get((String)"hammer")};

    public ComponentBreak(ResourceLocation registryName, ResourceLocation guiIcon) {
        super(registryName, guiIcon, new AttributeValuePair(Attribute.MAGNITUDE, 1.0f, 1.0f, 3.0f, 1.0f, 15.0f));
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<Component> modificationData, SpellContext context) {
        if (target.isBlock() && source.isPlayerCaster()) {
            boolean silkTouch = ((SpellModifierRing)ItemInit.SILK_TOUCH_RING.get()).isEquippedAndHasMana(source.getCaster(), 1.0f, true);
            int fortune_level = 0;
            if (!silkTouch) {
                if (((SpellModifierRing)ItemInit.FORTUNE_RING_GREATER.get()).isEquippedAndHasMana(source.getCaster(), 1.0f, true)) {
                    fortune_level = 3;
                } else if (((SpellModifierRing)ItemInit.FORTUNE_RING.get()).isEquippedAndHasMana(source.getCaster(), 1.0f, true)) {
                    fortune_level = 2;
                } else if (((SpellModifierRing)ItemInit.FORTUNE_RING_MINOR.get()).isEquippedAndHasMana(source.getCaster(), 1.0f, true)) {
                    fortune_level = 1;
                }
            }
            int magnitude = (int)modificationData.getValue(Attribute.MAGNITUDE);
            boolean captureDrops = false;
            boolean redirectDrops = false;
            if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemInit.COLLECTOR_RING_GREATER.get(), source.getCaster()).isPresent()) {
                captureDrops = true;
                redirectDrops = true;
            } else if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemInit.COLLECTOR_RING_LESSER.get(), source.getCaster()).isPresent()) {
                captureDrops = true;
            }
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            if (captureDrops) {
                drops.addAll(BlockUtils.destroyBlockCaptureDrops(source.getCaster(), (World)context.getWorld(), target.getBlock(), silkTouch, fortune_level, magnitude, this.emulatedTools));
                if (source.isPlayerCaster()) {
                    if (redirectDrops) {
                        ItemStack mainHand = source.getPlayer().func_184614_ca();
                        ItemStack offHand = source.getPlayer().func_184592_cb();
                        BlockPos redirLoc = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getLocation(mainHand.func_77973_b() == ItemInit.RUNE_MARKING.get() ? mainHand : offHand);
                        if (redirLoc != null) {
                            LazyOptional handler;
                            TileEntity te;
                            Direction redirFace = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getFace(mainHand.func_77973_b() == ItemInit.RUNE_MARKING.get() ? mainHand : offHand);
                            if (context.getWorld().func_195588_v(redirLoc) && (te = context.getWorld().func_175625_s(redirLoc)) != null && (handler = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, redirFace)).isPresent()) {
                                for (int i = 0; i < drops.size(); ++i) {
                                    if (!InventoryUtilities.mergeIntoInventory((IItemHandler)handler.resolve().get(), (ItemStack)drops.get(i))) continue;
                                    drops.remove(i);
                                    --i;
                                }
                            }
                        }
                    }
                    for (ItemStack stack : drops) {
                        if (source.getPlayer().func_191521_c(stack)) continue;
                        source.getPlayer().func_199701_a_(stack);
                    }
                }
                return ComponentApplicationResult.SUCCESS;
            }
            if (BlockUtils.destroyBlock(source.getCaster(), (World)context.getWorld(), target.getBlock(), true, silkTouch, fortune_level, magnitude, this.emulatedTools)) {
                return ComponentApplicationResult.SUCCESS;
            }
        }
        return ComponentApplicationResult.FAIL;
    }

    @Override
    public SoundEvent SoundEffect() {
        return SFX.Spell.Impact.Single.EARTH;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.EARTH;
    }

    @Override
    public void SpawnParticles(World world, Vector3d impact_position, int age, PlayerEntity caster, ISpellDefinition recipe) {
        if (age > 1) {
            return;
        }
        float particle_spread = 1.0f;
        float v = 0.1f;
        int particleCount = 10;
        for (int i = 0; i < particleCount; ++i) {
            Vector3d velocity = new Vector3d((double)(-v / 2.0f) + Math.random() * (double)v, Math.random() * (double)v, (double)(-v / 2.0f) + Math.random() * (double)v);
            world.func_195594_a((IParticleData)ParticleInit.DUST.get(), impact_position.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), impact_position.field_72448_b + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), impact_position.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
        }
    }

    @Override
    public float initialComplexity() {
        return 1.0f;
    }

    @Override
    public boolean targetsEntities() {
        return false;
    }

    @Override
    public int requiredXPForRote() {
        return 500;
    }
}

