/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.components;

import com.ma.api.affinity.Affinity;
import com.ma.api.capabilities.Faction;
import com.ma.api.particles.ParticleInit;
import com.ma.api.spells.ComponentApplicationResult;
import com.ma.api.spells.DamageTypes;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import java.util.Random;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class ComponentCauterize
extends Component {
    public ComponentCauterize(ResourceLocation registryName, ResourceLocation guiIcon) {
        super(registryName, guiIcon, new AttributeValuePair(Attribute.MAGNITUDE, 1.0f, 1.0f, 3.0f, 1.0f, 40.0f));
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<Component> modificationData, SpellContext context) {
        if (target.isLivingEntity() && !target.getLivingEntity().func_230279_az_() && target.getLivingEntity().func_70660_b(Effects.field_76426_n) == null) {
            int magnitude = (int)modificationData.getValue(Attribute.MAGNITUDE);
            int damage = 2 << magnitude - 1;
            target.getLivingEntity().func_70097_a(DamageTypes.causeSourcedFireDamage(source.getCaster()), (float)damage);
            target.getLivingEntity().func_195064_c(new EffectInstance(Effects.field_76428_l, 200, magnitude - 1, false, false, false, (EffectInstance)null));
            return ComponentApplicationResult.SUCCESS;
        }
        return ComponentApplicationResult.FAIL;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.FIRE;
    }

    @Override
    public void SpawnParticles(World world, Vector3d impact_position, int age, PlayerEntity caster, ISpellDefinition recipe) {
        if (age > 10) {
            return;
        }
        Random rndm = new Random();
        int particleCount = 10;
        for (int i = 0; i < particleCount; ++i) {
            world.func_195594_a((IParticleData)ParticleInit.FLAME.get(), impact_position.field_72450_a + (double)rndm.nextFloat() - 0.5, impact_position.field_72448_b + (double)rndm.nextFloat() - 0.5, impact_position.field_72449_c + (double)rndm.nextFloat() - 0.5, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public float initialComplexity() {
        return 20.0f;
    }

    @Override
    public boolean targetsBlocks() {
        return false;
    }

    @Override
    public Faction getFactionRequirement() {
        return Faction.DEMONS;
    }

    @Override
    public int requiredXPForRote() {
        return 100;
    }
}

