/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.components;

import com.ma.api.affinity.Affinity;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.api.spells.ComponentApplicationResult;
import com.ma.api.spells.SpellReagent;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.effects.EffectInit;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class ComponentChronoAnchor
extends Component {
    List<SpellReagent> reagents = new ArrayList<SpellReagent>();

    public ComponentChronoAnchor(ResourceLocation registryName, ResourceLocation guiIcon) {
        super(registryName, guiIcon, new AttributeValuePair(Attribute.DURATION, 60.0f, 15.0f, 480.0f, 15.0f, 4.0f));
        this.reagents.add(new SpellReagent(new ItemStack((IItemProvider)Items.field_151113_aN), false, true, true));
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<Component> modificationData, SpellContext context) {
        if (target.isLivingEntity() && target.getLivingEntity().func_70660_b((Effect)EffectInit.CHRONO_EXHAUSTION.get()) == null && target.getLivingEntity().func_70660_b((Effect)EffectInit.CHRONO_ANCHOR.get()) == null) {
            target.getLivingEntity().func_195064_c(new EffectInstance((Effect)EffectInit.CHRONO_ANCHOR.get(), (int)modificationData.getValue(Attribute.DURATION) * 20, 0, false, false, true, (EffectInstance)null));
            return ComponentApplicationResult.SUCCESS;
        }
        return ComponentApplicationResult.FAIL;
    }

    @Override
    public SoundEvent SoundEffect() {
        return SFX.Spell.Buff.ARCANE;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.ARCANE;
    }

    @Override
    public void SpawnParticles(World world, Vector3d impact_position, int age, PlayerEntity caster, ISpellDefinition recipe) {
        if (age > 10) {
            return;
        }
        float particle_spread = 1.0f;
        float v = 0.4f;
        int particleCount = 10;
        for (int i = 0; i < particleCount; ++i) {
            Vector3d velocity = new Vector3d(0.0, -Math.random() * (double)v, 0.0);
            world.func_195594_a((IParticleData)ParticleInit.ARCANE.get(), impact_position.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), impact_position.field_72448_b + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), impact_position.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
        }
    }

    @Override
    public boolean canBeChanneled() {
        return false;
    }

    @Override
    public float initialComplexity() {
        return 75.0f;
    }

    @Override
    public boolean targetsBlocks() {
        return false;
    }

    @Override
    public int requiredXPForRote() {
        return 200;
    }

    @Override
    public List<SpellReagent> getRequiredReagents(PlayerEntity caster) {
        return this.reagents;
    }
}

