/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.components;

import com.google.common.collect.ImmutableList;
import com.ma.api.affinity.Affinity;
import com.ma.api.spells.ComponentApplicationResult;
import com.ma.api.spells.SpellReagent;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.items.sorcery.ItemEntityCrystal;
import com.ma.tools.InventoryUtilities;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ComponentCrystallize
extends Component {
    private ImmutableList<SpellReagent> reagents = ImmutableList.of((Object)new SpellReagent(new ItemStack((IItemProvider)Items.field_151045_i), false, true, true));

    public ComponentCrystallize(ResourceLocation registryName, ResourceLocation guiIcon) {
        super(registryName, guiIcon, new AttributeValuePair(Attribute.MAGNITUDE, 1.0f, 1.0f, 4.0f, 1.0f, 10.0f));
    }

    @Override
    public int requiredXPForRote() {
        return 200;
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<Component> modificationData, SpellContext context) {
        if (!source.isPlayerCaster()) {
            return ComponentApplicationResult.FAIL;
        }
        if (target.isLivingEntity() && !(target.getLivingEntity() instanceof PlayerEntity) && target.getLivingEntity().func_184222_aU() && target.getLivingEntity().func_70089_S()) {
            int magnitude = (int)modificationData.getValue(Attribute.MAGNITUDE);
            int maxHP = 10 * magnitude;
            if (target.getLivingEntity().func_110138_aP() > (float)maxHP) {
                if (source.isPlayerCaster()) {
                    source.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("mana-and-artifice:components/crystallize.too_powerful"), Util.field_240973_b_);
                }
                return ComponentApplicationResult.FAIL;
            }
            if (context.countAffectedEntities(this) > 0 && !InventoryUtilities.removeItemFromInventory(new ItemStack((IItemProvider)Items.field_151045_i), true, false, (IInventory)source.getPlayer().field_71071_by)) {
                return ComponentApplicationResult.FAIL;
            }
            ItemStack stack = ItemEntityCrystal.storeEntity(target.getEntity());
            target.getEntity().func_199701_a_(stack);
            target.getEntity().remove(false);
            return ComponentApplicationResult.SUCCESS;
        }
        return ComponentApplicationResult.FAIL;
    }

    @Override
    public boolean targetsBlocks() {
        return false;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.ARCANE;
    }

    @Override
    public float initialComplexity() {
        return 10.0f;
    }

    @Override
    public boolean targetsEntities() {
        return true;
    }

    @Override
    public List<SpellReagent> getRequiredReagents(PlayerEntity caster) {
        return this.reagents;
    }
}

