/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.components;

import com.ma.api.affinity.Affinity;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.api.spells.ComponentApplicationResult;
import com.ma.api.spells.DamageTypes;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.effects.EffectInit;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class ComponentDrown
extends Component {
    public ComponentDrown(ResourceLocation registryName, ResourceLocation guiIcon) {
        super(registryName, guiIcon, new AttributeValuePair(Attribute.MAGNITUDE, 1.0f, 1.0f, 3.0f, 1.0f, 15.0f), new AttributeValuePair(Attribute.DAMAGE, 10.0f, 10.0f, 30.0f, 1.0f, 2.0f), new AttributeValuePair(Attribute.DURATION, 5.0f, 2.0f, 5.0f, 1.0f, 10.0f));
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<Component> modificationData, SpellContext context) {
        if (target.isLivingEntity() && !target.getLivingEntity().func_70648_aU() && !EffectUtils.func_205133_c((LivingEntity)target.getLivingEntity())) {
            int magnitude = (int)modificationData.getValue(Attribute.MAGNITUDE);
            int air_per_magnitude = (int)((float)target.getLivingEntity().func_205010_bg() * 0.2f);
            int air_removed = air_per_magnitude * magnitude;
            target.getLivingEntity().func_70050_g(target.getLivingEntity().func_70086_ai() - air_removed);
            if (target.getLivingEntity().func_70086_ai() <= 0) {
                target.getLivingEntity().func_70097_a(DamageTypes.causeSourcedDrownDamage(source.getCaster()), modificationData.getValue(Attribute.DAMAGE));
            }
            target.getLivingEntity().func_195064_c(new EffectInstance((Effect)EffectInit.ASPHYXIATE.get(), (int)modificationData.getValue(Attribute.DURATION) * 20, 0));
            return ComponentApplicationResult.SUCCESS;
        }
        return ComponentApplicationResult.FAIL;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.WATER;
    }

    @Override
    public float initialComplexity() {
        return 40.0f;
    }

    @Override
    public SoundEvent SoundEffect() {
        return SFX.Spell.Impact.Single.WATER;
    }

    @Override
    public void SpawnParticles(World world, Vector3d impact_position, int age, PlayerEntity caster, ISpellDefinition recipe) {
        if (age > 10) {
            return;
        }
        float particle_spread = 1.0f;
        float v = 1.0f;
        int particleCount = 10;
        for (int i = 0; i < particleCount; ++i) {
            Vector3d velocity = new Vector3d(0.0, Math.random() * (double)v, 0.0);
            world.func_195594_a((IParticleData)ParticleInit.WATER.get(), impact_position.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), impact_position.field_72448_b + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), impact_position.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
        }
    }

    @Override
    public boolean targetsBlocks() {
        return false;
    }

    @Override
    public int requiredXPForRote() {
        return 500;
    }
}

