/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.components;

import com.ma.api.affinity.Affinity;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.api.spells.ComponentApplicationResult;
import com.ma.api.spells.DamageTypes;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.blocks.BlockInit;
import com.ma.tools.BlockUtils;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class ComponentFireDamage
extends Component {
    public ComponentFireDamage(ResourceLocation registryName, ResourceLocation icon) {
        super(registryName, icon, new AttributeValuePair(Attribute.DAMAGE, 5.0f, 1.0f, 20.0f, 0.5f, 3.0f), new AttributeValuePair(Attribute.DURATION, 3.0f, 0.0f, 10.0f, 1.0f, 2.0f));
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<Component> modificationData, SpellContext context) {
        if (target.isEntity()) {
            if (!(target.getEntity() instanceof ItemEntity)) {
                target.getEntity().func_70015_d((int)modificationData.getValue(Attribute.DURATION));
                target.getEntity().func_70097_a(DamageTypes.causeSourcedFireDamage(source.getCaster()), modificationData.getValue(Attribute.DAMAGE));
                return ComponentApplicationResult.SUCCESS;
            }
        } else if (target.isBlock() && modificationData.getValue(Attribute.DURATION) > 0.0f && context.getWorld().func_175623_d(target.getBlock().func_177984_a())) {
            if (context.getSpell().getAffinity().containsKey((Object)Affinity.HELLFIRE)) {
                BlockUtils.placeBlock(context.getWorld(), target.getBlock().func_177984_a(), target.getBlockFace(this), ((Block)BlockInit.HELLFIRE.get()).func_176223_P(), source.getPlayer());
            } else {
                BlockUtils.placeBlock(context.getWorld(), target.getBlock().func_177984_a(), target.getBlockFace(this), Blocks.field_150480_ab.func_176223_P(), source.getPlayer());
            }
            return ComponentApplicationResult.SUCCESS;
        }
        return ComponentApplicationResult.FAIL;
    }

    @Override
    public void SpawnParticles(World world, Vector3d impact_position, int age, PlayerEntity caster, ISpellDefinition recipe) {
        Random rndm = new Random(1234L);
        if (age < 5) {
            for (int i = 0; i < 25; ++i) {
                if (recipe.getAffinity().containsKey((Object)Affinity.HELLFIRE)) {
                    world.func_195594_a((IParticleData)ParticleInit.HELLFIRE.get(), impact_position.field_72450_a + (double)rndm.nextFloat() - 0.5, impact_position.field_72448_b + (double)rndm.nextFloat() - 0.5, impact_position.field_72449_c + (double)rndm.nextFloat() - 0.5, 0.0, 0.0, 0.0);
                    continue;
                }
                world.func_195594_a((IParticleData)ParticleInit.FLAME.get(), impact_position.field_72450_a + (double)rndm.nextFloat() - 0.5, impact_position.field_72448_b + (double)rndm.nextFloat() - 0.5, impact_position.field_72449_c + (double)rndm.nextFloat() - 0.5, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public SoundEvent SoundEffect() {
        return SFX.Spell.Impact.Single.FIRE;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.FIRE;
    }

    @Override
    public float initialComplexity() {
        return 10.0f;
    }

    @Override
    public int requiredXPForRote() {
        return 500;
    }
}

