/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.components;

import com.ma.api.affinity.Affinity;
import com.ma.api.capabilities.IPlayerMagic;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.api.spells.ComponentApplicationResult;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class ComponentFling
extends Component {
    public ComponentFling(ResourceLocation registryName, ResourceLocation guiIcon) {
        super(registryName, guiIcon, new AttributeValuePair(Attribute.SPEED, 1.0f, 1.0f, 3.0f, 1.0f, 5.0f));
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<Component> modificationData, SpellContext context) {
        float speed = modificationData.getValue(Attribute.SPEED);
        if (target.isLivingEntity()) {
            LivingEntity le = target.getLivingEntity();
            float max_velocity = 2.0f;
            if (source.hasCasterReference() && le == source.getCaster()) {
                if (source.isPlayerCaster()) {
                    IPlayerMagic magic = (IPlayerMagic)source.getPlayer().getCapability(PlayerMagicProvider.MAGIC).orElse(null);
                    if (magic == null || magic.getAirCasts() >= magic.getAirCastLimit(source.getPlayer())) {
                        return ComponentApplicationResult.FAIL;
                    }
                    if (!source.getPlayer().func_233570_aj_()) {
                        magic.incrementAirCasts(source.getPlayer());
                    }
                }
                Vector3d motion = source.getCaster().func_70040_Z().func_72432_b().func_186678_a(0.5);
                motion = motion.func_186678_a((double)(speed * 2.0f));
                source.getCaster().func_70024_g(motion.field_72450_a, motion.field_72448_b, motion.field_72449_c);
                motion = source.getCaster().func_213322_ci();
                source.getCaster().func_213293_j(Math.min((double)max_velocity, motion.field_72450_a), Math.min((double)max_velocity, motion.field_72448_b), Math.min((double)max_velocity, motion.field_72449_c));
                source.getCaster().field_70133_I = true;
                if (source.isPlayerCaster()) {
                    ((ServerPlayerEntity)source.getPlayer()).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)le));
                }
                return ComponentApplicationResult.SUCCESS;
            }
            if (le instanceof PlayerEntity) {
                PlayerEntity targetPlayer = (PlayerEntity)le;
                Vector3d motion = source.hasCasterReference() ? source.getCaster().func_70040_Z().func_72432_b().func_186678_a(0.5) : targetPlayer.func_70040_Z().func_72432_b().func_186678_a(0.5);
                motion = motion.func_186678_a((double)(speed * 2.0f));
                targetPlayer.func_70024_g(motion.field_72450_a, motion.field_72448_b, motion.field_72449_c);
                motion = targetPlayer.func_213322_ci();
                targetPlayer.func_213293_j(Math.min((double)max_velocity, motion.field_72450_a), Math.min((double)max_velocity, motion.field_72448_b), Math.min((double)max_velocity, motion.field_72449_c));
                targetPlayer.field_70133_I = true;
                ((ServerPlayerEntity)targetPlayer).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)targetPlayer));
                return ComponentApplicationResult.SUCCESS;
            }
            float mX = (float)(source.getOrigin().func_82615_a() - target.getLivingEntity().func_226277_ct_());
            float mZ = (float)(source.getOrigin().func_82616_c() - target.getLivingEntity().func_226281_cx_());
            le.func_233627_a_(speed, (double)mX, (double)mZ);
            le.func_70024_g(0.0, (double)(0.2f * speed), 0.0);
            if (le instanceof CreatureEntity) {
                ((CreatureEntity)le).func_70661_as().func_75499_g();
            }
            return ComponentApplicationResult.SUCCESS;
        }
        if (target.isEntity() && target.getEntity() instanceof ProjectileEntity) {
            float mX = (float)(source.getOrigin().func_82615_a() - target.getEntity().func_226277_ct_());
            float mZ = (float)(source.getOrigin().func_82616_c() - target.getEntity().func_226281_cx_());
            target.getEntity().field_70160_al = true;
            Vector3d vector3d = target.getEntity().func_213322_ci();
            Vector3d vector3d1 = new Vector3d((double)mX, 0.0, (double)mZ).func_72432_b().func_186678_a((double)speed);
            target.getEntity().func_213293_j(vector3d.field_72450_a / 2.0 - vector3d1.field_72450_a, target.getEntity().func_233570_aj_() ? Math.min(0.4, vector3d.field_72448_b / 2.0 + (double)speed) : vector3d.field_72448_b, vector3d.field_72449_c / 2.0 - vector3d1.field_72449_c);
            return ComponentApplicationResult.SUCCESS;
        }
        return ComponentApplicationResult.FAIL;
    }

    @Override
    public SoundEvent SoundEffect() {
        return SFX.Spell.Impact.Single.WIND;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.WIND;
    }

    @Override
    public void SpawnParticles(World world, Vector3d impact_position, int age, PlayerEntity caster, ISpellDefinition recipe) {
        if (age > 10) {
            return;
        }
        float particle_spread = 1.0f;
        int particleCount = 10;
        Vector3d velocity = caster.func_70040_Z();
        for (int i = 0; i < particleCount; ++i) {
            world.func_195594_a((IParticleData)ParticleInit.AIR_VELOCITY.get(), impact_position.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), impact_position.field_72448_b + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), impact_position.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
        }
    }

    @Override
    public float initialComplexity() {
        return 10.0f;
    }

    @Override
    public boolean targetsBlocks() {
        return false;
    }

    @Override
    public int requiredXPForRote() {
        return 200;
    }
}

