/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.components;

import com.ma.api.affinity.Affinity;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.api.spells.ComponentApplicationResult;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.blocks.BlockInit;
import com.ma.tools.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayerFactory;

public class ComponentLight
extends Component {
    public ComponentLight(ResourceLocation registryName, ResourceLocation guiIcon) {
        super(registryName, guiIcon, new AttributeValuePair(Attribute.DURATION, 15.0f, 15.0f, 60.0f, 5.0f, 2.0f));
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<Component> modificationData, SpellContext context) {
        if (target.isBlock() && context.getWorld().isAreaLoaded(target.getBlock(), 1)) {
            if (context.countAffectedBlocks(this) > 0) {
                return ComponentApplicationResult.FAIL;
            }
            BlockPos pos = target.getBlock().func_177971_a(target.getBlockFace(this).func_176730_m());
            int count = 0;
            while (count < 5 && !this.isPosValidForPlacement((World)context.getWorld(), pos)) {
                ++count;
                pos = pos.func_177984_a();
            }
            if (this.isPosValidForPlacement((World)context.getWorld(), pos)) {
                PlayerEntity player = source.isPlayerCaster() ? source.getPlayer() : FakePlayerFactory.getMinecraft((ServerWorld)context.getWorld());
                BlockRayTraceResult brtr = new BlockRayTraceResult(new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), target.getBlockFace(this), pos, true);
                BlockItemUseContext biuc = new BlockItemUseContext(player, Hand.MAIN_HAND, ItemStack.field_190927_a, brtr);
                BlockUtils.placeBlock(context.getWorld(), pos, target.getBlockFace(this), ((Block)BlockInit.MAGE_LIGHT.get()).func_196258_a(biuc), source.getPlayer());
                return ComponentApplicationResult.SUCCESS;
            }
        } else if (target.isLivingEntity() && context.getWorld().isAreaLoaded(target.getEntity().func_233580_cy_(), 1)) {
            int duration = Math.max((int)modificationData.getValue(Attribute.DURATION), 300);
            target.getLivingEntity().func_195064_c(new EffectInstance(Effects.field_188423_x, duration));
            return ComponentApplicationResult.SUCCESS;
        }
        return ComponentApplicationResult.FAIL;
    }

    private boolean isPosValidForPlacement(World world, BlockPos pos) {
        if (world.func_175623_d(pos)) {
            return true;
        }
        return world.func_204610_c(pos).func_206889_d() && world.func_180495_p(pos).func_177230_c() == Blocks.field_150355_j;
    }

    @Override
    public SoundEvent SoundEffect() {
        return SFX.Spell.Impact.Single.ARCANE;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.ARCANE;
    }

    @Override
    public void SpawnParticles(World world, Vector3d impact_position, int age, PlayerEntity caster, ISpellDefinition recipe) {
        if (age > 1) {
            return;
        }
        BlockPos imp = new BlockPos(impact_position);
        for (int i = 0; i < 50; ++i) {
            world.func_195594_a((IParticleData)ParticleInit.BLUE_SPARKLE_GRAVITY.get(), (double)imp.func_177958_n() + 0.5, (double)imp.func_177956_o() + 0.5, (double)imp.func_177952_p() + 0.5, -0.25 + Math.random() * 0.5, Math.random() * 0.25, -0.25 + Math.random() * 0.5);
        }
    }

    @Override
    public boolean canBeChanneled() {
        return false;
    }

    @Override
    public float initialComplexity() {
        return 5.0f;
    }

    @Override
    public int requiredXPForRote() {
        return 100;
    }
}

