/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.components;

import com.ma.api.affinity.Affinity;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.api.spells.ComponentApplicationResult;
import com.ma.api.spells.DamageTypes;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.network.ServerMessageDispatcher;
import com.ma.tools.math.MathUtilities;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class ComponentLightningDamage
extends Component {
    public ComponentLightningDamage(ResourceLocation registryName, ResourceLocation icon) {
        super(registryName, icon, new AttributeValuePair(Attribute.DAMAGE, 5.0f, 1.0f, 20.0f, 0.5f, 3.0f), new AttributeValuePair(Attribute.MAGNITUDE, 3.0f, 0.0f, 10.0f, 1.0f, 2.0f), new AttributeValuePair(Attribute.RADIUS, 1.0f, 1.0f, 10.0f, 1.0f, 3.0f));
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<Component> modificationData, SpellContext context) {
        float damage = modificationData.getValue(Attribute.DAMAGE);
        float branchChance = MathUtilities.clamp01(modificationData.getValue(Attribute.MAGNITUDE) / 10.0f);
        float branchRadius = modificationData.getValue(Attribute.RADIUS);
        Vector3d lastTargetPosition = target.getPosition();
        int hits = 0;
        if (target.isEntity()) {
            if (!(target.getEntity() instanceof ItemEntity)) {
                target.getEntity().func_70097_a(DamageTypes.causeSourcedLightningDamage(source.getCaster()), damage);
                context.addAffectedEntity(this, target.getEntity());
                ++hits;
            }
            lastTargetPosition = target.getEntity().func_213303_ch().func_178787_e(new Vector3d(0.0, (double)target.getEntity().func_70047_e(), 0.0));
        }
        while (Math.random() < (double)branchChance) {
            Vector3d checkTargetPosition = lastTargetPosition;
            List entities = context.getWorld().func_175647_a(LivingEntity.class, new AxisAlignedBB(new BlockPos(lastTargetPosition)).func_186662_g((double)branchRadius), e -> {
                if (source.hasCasterReference() && e == source.getCaster()) {
                    return false;
                }
                Vector3d entitySightPos = new Vector3d(e.func_226277_ct_(), e.func_226280_cw_(), e.func_226281_cx_());
                boolean visionCheck = context.getWorld().func_217299_a(new RayTraceContext(checkTargetPosition, entitySightPos, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, null)).func_216346_c() == RayTraceResult.Type.MISS;
                return e.func_70089_S() && !context.hasEntityBeenAffected(this, (Entity)e) && visionCheck;
            });
            if (entities.size() == 0) break;
            Vector3d sortLTP = lastTargetPosition;
            entities.sort((o1, o2) -> {
                Double o1Dist = o1.func_195048_a(sortLTP);
                Double o2Dist = o2.func_195048_a(sortLTP);
                return o1Dist.compareTo(o2Dist);
            });
            LivingEntity nextTarget = (LivingEntity)entities.get(0);
            context.addAffectedEntity(this, (Entity)nextTarget);
            nextTarget.func_70097_a(DamageTypes.causeSourcedLightningDamage(source.getCaster()), damage);
            ServerMessageDispatcher.sendParticleSpawn(lastTargetPosition.field_72450_a, lastTargetPosition.field_72448_b, lastTargetPosition.field_72449_c, nextTarget.func_226277_ct_(), nextTarget.func_226278_cu_() + (double)nextTarget.func_70047_e(), nextTarget.func_226281_cx_(), 64.0f, (RegistryKey<World>)context.getWorld().func_234923_W_(), (BasicParticleType)ParticleInit.LIGHTNING_BOLT.get());
            lastTargetPosition = nextTarget.func_213303_ch().func_178787_e(new Vector3d(0.0, (double)nextTarget.func_70047_e(), 0.0));
            branchChance *= 0.75f;
            ++hits;
        }
        return hits > 0 ? ComponentApplicationResult.SUCCESS : ComponentApplicationResult.FAIL;
    }

    @Override
    public SoundEvent SoundEffect() {
        return SFX.Spell.Impact.Single.LIGHTNING;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.LIGHTNING;
    }

    @Override
    public void SpawnParticles(World world, Vector3d impact_position, int age, PlayerEntity caster, ISpellDefinition recipe) {
        if (age > 1) {
            return;
        }
        float particle_spread = 1.0f;
        float v = 0.4f;
        int particleCount = 10;
        for (int i = 0; i < particleCount; ++i) {
            Vector3d velocity = new Vector3d((double)(-v / 2.0f) + Math.random() * (double)v, Math.random() * (double)v, (double)(-v / 2.0f) + Math.random() * (double)v);
            world.func_195594_a((IParticleData)ParticleInit.SPARKLE_VELOCITY.get(), impact_position.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), impact_position.field_72448_b + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), impact_position.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
        }
    }

    @Override
    public float initialComplexity() {
        return 10.0f;
    }

    @Override
    public boolean targetsBlocks() {
        return false;
    }

    @Override
    public int requiredXPForRote() {
        return 500;
    }
}

