/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.components;

import com.ma.api.affinity.Affinity;
import com.ma.api.capabilities.Faction;
import com.ma.api.particles.ParticleInit;
import com.ma.api.spells.ComponentApplicationResult;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.tools.TeleportHelper;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.server.ServerWorld;

public class ComponentNethergate
extends Component {
    public ComponentNethergate(ResourceLocation registryName, ResourceLocation guiIcon) {
        super(registryName, guiIcon, new AttributeValuePair[0]);
    }

    @Override
    public int requiredXPForRote() {
        return 100;
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<Component> modificationData, SpellContext context) {
        if (target.isLivingEntity()) {
            ServerWorld destination;
            MinecraftServer server = context.getWorld().func_73046_m();
            ServerWorld origin = context.getWorld();
            if (context.getWorld().func_234923_W_() == World.field_234918_g_) {
                destination = server.func_71218_a(World.field_234919_h_);
            } else if (context.getWorld().func_234923_W_() == World.field_234919_h_) {
                destination = server.func_71218_a(World.field_234918_g_);
            } else {
                return ComponentApplicationResult.FAIL;
            }
            Vector3d targetPosition = this.calculateDimensionDifferencePosition(target.getLivingEntity().func_213303_ch(), origin, destination);
            this.clearTeleportArea(destination, new BlockPos(targetPosition));
            TeleportHelper.teleportEntity((Entity)target.getLivingEntity(), (RegistryKey<World>)destination.func_234923_W_(), targetPosition);
            return ComponentApplicationResult.SUCCESS;
        }
        return ComponentApplicationResult.FAIL;
    }

    private void clearTeleportArea(ServerWorld world, BlockPos origin) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = 0; j <= 2; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    BlockPos target = origin.func_177982_a(i, j, k);
                    if (world.func_175623_d(target) || world.func_175625_s(target) != null || world.func_180495_p(target).func_177230_c() == Blocks.field_150357_h) continue;
                    world.func_175656_a(target, Blocks.field_150350_a.func_176223_P());
                }
            }
        }
    }

    protected Vector3d calculateDimensionDifferencePosition(Vector3d origin, ServerWorld from, ServerWorld to) {
        WorldBorder worldborder = to.func_175723_af();
        double minX = Math.max(-2.9999872E7, worldborder.func_177726_b() + 16.0);
        double minZ = Math.max(-2.9999872E7, worldborder.func_177736_c() + 16.0);
        double maxX = Math.min(2.9999872E7, worldborder.func_177728_d() - 16.0);
        double maxZ = Math.min(2.9999872E7, worldborder.func_177733_e() - 16.0);
        double scale = DimensionType.func_242715_a((DimensionType)from.func_230315_m_(), (DimensionType)to.func_230315_m_());
        BlockPos scaledPos = new BlockPos(MathHelper.func_151237_a((double)(origin.field_72450_a * scale), (double)minX, (double)maxX), MathHelper.func_151237_a((double)origin.field_72448_b, (double)5.0, (double)(to.func_217301_I() - 2)), MathHelper.func_151237_a((double)(origin.field_72449_c * scale), (double)minZ, (double)maxZ));
        BlockPos searchPos = new BlockPos((Vector3i)scaledPos);
        while (!to.func_175623_d(searchPos) && searchPos.func_177956_o() < to.func_217301_I() - 2) {
            searchPos = searchPos.func_177984_a();
        }
        while (to.func_175623_d(searchPos.func_177977_b()) && searchPos.func_177956_o() > 5) {
            searchPos = searchPos.func_177977_b();
        }
        scaledPos = searchPos;
        return new Vector3d((double)scaledPos.func_177958_n() + 0.5, (double)scaledPos.func_177956_o(), (double)scaledPos.func_177952_p() + 0.5);
    }

    @Override
    public void SpawnParticles(World world, Vector3d impact_position, int age, PlayerEntity caster, ISpellDefinition recipe) {
        if (age == 0) {
            float particle_spread = 1.0f;
            float v = 1.0f;
            int particleCount = 25;
            for (int i = 0; i < particleCount; ++i) {
                Vector3d velocity = new Vector3d(0.0, Math.random() * (double)v, 0.0);
                world.func_195594_a((IParticleData)ParticleInit.ENDER_VELOCITY.get(), impact_position.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), impact_position.field_72448_b + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), impact_position.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
            }
        }
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.ENDER;
    }

    @Override
    public float initialComplexity() {
        return 50.0f;
    }

    @Override
    public Faction getFactionRequirement() {
        return Faction.DEMONS;
    }
}

