/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.components;

import com.ma.api.affinity.Affinity;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.api.spells.ComponentApplicationResult;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.spells.components.PotionEffectComponent;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class ComponentPoison
extends PotionEffectComponent {
    public ComponentPoison(ResourceLocation registryName, ResourceLocation guiIcon) {
        super(registryName, guiIcon, Effects.field_76436_u, new AttributeValuePair(Attribute.DURATION, 5.0f, 5.0f, 15.0f, 1.0f, 5.0f), new AttributeValuePair(Attribute.MAGNITUDE, 1.0f, 1.0f, 3.0f, 1.0f, 20.0f));
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<Component> modificationData, SpellContext context) {
        ComponentApplicationResult result = super.ApplyEffect(source, target, modificationData, context);
        if (result == ComponentApplicationResult.SUCCESS && source.hasCasterReference()) {
            target.getLivingEntity().func_70604_c(source.getCaster());
        }
        return result;
    }

    @Override
    public SoundEvent SoundEffect() {
        return SFX.Spell.Buff.EARTH;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.EARTH;
    }

    @Override
    public void SpawnParticles(World world, Vector3d impact_position, int age, PlayerEntity caster, ISpellDefinition recipe) {
        int i;
        if (age > 10) {
            return;
        }
        float particle_spread = 1.0f;
        int particleCount = 5;
        for (i = 0; i < particleCount; ++i) {
            world.func_195594_a((IParticleData)ParticleInit.EARTH.get(), impact_position.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), impact_position.field_72448_b + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), impact_position.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), (double)0.02745098f, 0.21960784494876862, (double)0.02745098f);
        }
        for (i = 0; i < particleCount; ++i) {
            world.func_195594_a((IParticleData)ParticleInit.EARTH.get(), impact_position.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), impact_position.field_72448_b + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), impact_position.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), 0.2823529541492462, 0.0470588244497776, 0.41960784792900085);
        }
    }

    @Override
    public float initialComplexity() {
        return 10.0f;
    }

    @Override
    public boolean targetsBlocks() {
        return false;
    }

    @Override
    public int requiredXPForRote() {
        return 100;
    }
}

