/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.components;

import com.ma.api.affinity.Affinity;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.api.spells.ComponentApplicationResult;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.tools.TeleportHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class ComponentTransplace
extends Component {
    public ComponentTransplace(ResourceLocation registryName, ResourceLocation guiIcon) {
        super(registryName, guiIcon, new AttributeValuePair[0]);
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<Component> modificationData, SpellContext context) {
        if (source.getCaster() == null) {
            return ComponentApplicationResult.FAIL;
        }
        if (target.isLivingEntity() && source.getCaster().field_70170_p.func_234923_W_().equals(target.getLivingEntity().field_70170_p.func_234923_W_())) {
            Vector3d casterPos = source.getOrigin();
            Vector3d targetPos = target.getLivingEntity().func_213303_ch();
            TeleportHelper.teleportEntity((Entity)source.getCaster(), (RegistryKey<World>)context.getWorld().func_234923_W_(), targetPos);
            TeleportHelper.teleportEntity((Entity)target.getLivingEntity(), (RegistryKey<World>)context.getWorld().func_234923_W_(), casterPos);
            return ComponentApplicationResult.SUCCESS;
        }
        return ComponentApplicationResult.FAIL;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.ENDER;
    }

    @Override
    public SoundEvent SoundEffect() {
        return SFX.Spell.Impact.Single.ENDER;
    }

    @Override
    public void SpawnParticles(World world, Vector3d impact_position, int age, PlayerEntity caster, ISpellDefinition recipe) {
        if (age < 5) {
            Vector3d rotationOffset = new Vector3d(1.5, 0.0, 0.0);
            BlockPos bp = new BlockPos(impact_position).func_177982_a(0, -1, 0);
            for (int angle = 0; angle < 360; angle += 30) {
                Vector3d point = rotationOffset.func_178785_b((float)((double)angle * Math.PI / 180.0));
                world.func_195594_a((IParticleData)ParticleInit.ENDER.get(), (double)((float)bp.func_177958_n() + 0.5f) + point.field_72450_a, (double)bp.func_177956_o(), (double)((float)bp.func_177952_p() + 0.5f) + point.field_72449_c, (double)((float)bp.func_177958_n() + 0.5f), (double)(bp.func_177956_o() + 2), (double)((float)bp.func_177952_p() + 0.5f));
            }
        }
    }

    @Override
    public float initialComplexity() {
        return 20.0f;
    }

    @Override
    public boolean targetsBlocks() {
        return false;
    }

    @Override
    public int requiredXPForRote() {
        return 100;
    }
}

