/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.components;

import com.ma.api.spells.ComponentApplicationResult;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.RegistryObject;

public abstract class PotionEffectComponent
extends Component {
    protected final Effect effect;
    protected final RegistryObject<Effect> registry_effect;
    protected final boolean modifiesMagnitude;
    protected final boolean modifiesDuration;

    public PotionEffectComponent(ResourceLocation registryName, ResourceLocation guiIcon, Effect effect, AttributeValuePair ... attributeValuePairs) {
        super(registryName, guiIcon, attributeValuePairs);
        this.effect = effect;
        this.registry_effect = null;
        List<AttributeValuePair> pairs = Arrays.asList(attributeValuePairs);
        this.modifiesDuration = pairs.stream().anyMatch(p -> p.getAttribute() == Attribute.DURATION);
        this.modifiesMagnitude = pairs.stream().anyMatch(p -> p.getAttribute() == Attribute.MAGNITUDE);
    }

    public PotionEffectComponent(ResourceLocation registryName, ResourceLocation guiIcon, RegistryObject<Effect> effect, AttributeValuePair ... attributeValuePairs) {
        super(registryName, guiIcon, attributeValuePairs);
        this.effect = null;
        this.registry_effect = effect;
        List<AttributeValuePair> pairs = Arrays.asList(attributeValuePairs);
        this.modifiesDuration = pairs.stream().anyMatch(p -> p.getAttribute() == Attribute.DURATION);
        this.modifiesMagnitude = pairs.stream().anyMatch(p -> p.getAttribute() == Attribute.MAGNITUDE);
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<Component> modificationData, SpellContext context) {
        if (target.isLivingEntity()) {
            if (this.applicationPredicate(target.getLivingEntity())) {
                target.getLivingEntity().func_195064_c(new EffectInstance(this.effect != null ? this.effect : (Effect)this.registry_effect.get(), this.modifiesDuration ? (int)modificationData.getValue(Attribute.DURATION) * 20 : 1, this.modifiesMagnitude ? (int)modificationData.getValue(Attribute.MAGNITUDE) - 1 : 0, false, false, true, (EffectInstance)null));
                return ComponentApplicationResult.SUCCESS;
            }
            if (source.isPlayerCaster()) {
                source.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("mana-and-artifice:components/potion_effect_component.cannot_apply", new Object[]{new TranslationTextComponent(target.getLivingEntity().func_200600_R().func_210760_d()).getString()}), Util.field_240973_b_);
            }
        }
        return ComponentApplicationResult.FAIL;
    }

    protected boolean applicationPredicate(LivingEntity target) {
        return true;
    }
}

