/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.crafting;

import com.ma.ManaAndArtifice;
import com.ma.Registries;
import com.ma.api.affinity.Affinity;
import com.ma.api.capabilities.Faction;
import com.ma.api.capabilities.IPlayerProgression;
import com.ma.api.spells.ComponentApplicationResult;
import com.ma.api.spells.SpellCastingResult;
import com.ma.api.spells.SpellReagent;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.parts.Modifier;
import com.ma.api.spells.parts.Shape;
import com.ma.items.ItemInit;
import com.ma.recipes.ItemAndPatternRecipeHelper;
import com.ma.recipes.RecipeInit;
import com.ma.recipes.spells.ComponentRecipe;
import com.ma.recipes.spells.ModifierRecipe;
import com.ma.recipes.spells.ShapeRecipe;
import com.ma.spells.crafting.ModifiedSpellPart;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class SpellRecipe
implements ISpellDefinition {
    private static int MINOR_FOCUS_COMPLEXITY = 10;
    private static int LESSER_FOCUS_COMPLEXITY = 20;
    private static int GREATER_FOCUS_COMPLEXITY = 50;
    public static final int MAX_COMPONENTS = 5;
    public static final int MAX_MODIFIERS = 3;
    public static final String SPELL_COMPOUND_TAG = "spell";
    private ModifiedSpellPart<Shape> shape;
    private ArrayList<ModifiedSpellPart<Component>> components;
    private Modifier[] modifiers;
    private Affinity overrideAffinity = Affinity.UNKNOWN;
    private float complexity;
    private float calculatedManaCost;
    private float overrideManaCost = -1.0f;
    private boolean isMysterious = true;

    public SpellRecipe() {
        this.modifiers = new Modifier[3];
        this.components = new ArrayList(5);
    }

    public SpellRecipe setShape(Shape shape) {
        this.shape = shape != null ? new ModifiedSpellPart<Shape>(shape) : null;
        this.recalculateSpellNumbers();
        return this;
    }

    public SpellRecipe addComponent(Component component) {
        if (this.components.size() < 5 && !this.components.stream().anyMatch(c -> c.getPart() == component)) {
            this.components.add(new ModifiedSpellPart<Component>(component));
            this.recalculateSpellNumbers();
        }
        return this;
    }

    public void removeComponent(int index) {
        if (index < 0 || index >= this.components.size()) {
            return;
        }
        this.components.remove(index);
        this.recalculateSpellNumbers();
    }

    public void setModifier(Modifier modifier, int index) {
        if (index < 0 || index >= 3) {
            return;
        }
        if (modifier == null && this.modifiers[index] != null) {
            for (Attribute attribute : this.modifiers[index].getModifiedAttributes()) {
                if (this.shape != null) {
                    this.shape.resetValueToDefault(attribute);
                }
                for (ModifiedSpellPart<Component> component : this.components) {
                    if (component == null) continue;
                    component.resetValueToDefault(attribute);
                }
            }
        }
        this.modifiers[index] = modifier;
        this.recalculateSpellNumbers();
    }

    public boolean addModifier(Modifier modifier) {
        for (int i = 0; i < 3; ++i) {
            if (this.modifiers[i] != null) continue;
            this.modifiers[i] = modifier;
            return true;
        }
        return false;
    }

    private void recalculateSpellNumbers() {
        this.calculateComplexity();
        this.calculateManaCost();
    }

    public ModifiedSpellPart<Shape> getShape() {
        return this.shape;
    }

    @Nullable
    public ModifiedSpellPart<Component> getComponent(int index) {
        if (index < 0 || index >= this.components.size()) {
            return null;
        }
        return this.components.get(index);
    }

    @Override
    public int countComponents() {
        return this.components.size();
    }

    @Override
    public void clearComponents() {
        this.components.clear();
    }

    @Override
    public int findComponent(Component component) {
        OptionalInt index = IntStream.range(0, this.components.size()).filter(idx -> this.components.get(idx).getPart() == component).findFirst();
        return index.isPresent() ? index.getAsInt() : -1;
    }

    @Override
    public List<IModifiedSpellPart<Component>> getComponents() {
        return this.components.stream().map(c -> c).collect(Collectors.toList());
    }

    @Override
    public void iterateComponents(Consumer<IModifiedSpellPart<Component>> consumer) {
        for (ModifiedSpellPart<Component> component : this.components) {
            consumer.accept(component);
        }
    }

    @Override
    public Modifier getModifier(int index) {
        if (index < 0 || index >= 3) {
            return null;
        }
        return this.modifiers[index];
    }

    @Override
    public List<Modifier> getModifiers() {
        return Arrays.asList(this.modifiers).stream().filter(m -> m != null).collect(Collectors.toList());
    }

    public boolean isAttributeModifiable(Attribute attr) {
        for (Modifier m : this.modifiers) {
            if (m == null || !m.modifiesType(attr)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int countModifiers() {
        int c = 0;
        for (Modifier m : this.modifiers) {
            if (m == null) continue;
            ++c;
        }
        return c;
    }

    @Override
    public float getComplexity() {
        return this.complexity;
    }

    @Override
    public float getManaCost() {
        return this.overrideManaCost == -1.0f ? this.calculatedManaCost : this.overrideManaCost;
    }

    @Override
    public void setManaCost(float manaCost) {
        this.overrideManaCost = manaCost;
    }

    @Override
    public boolean isValid() {
        if (this.shape == null || this.shape.getPart() == null || this.components.stream().allMatch(c -> c == null)) {
            return false;
        }
        return !this.shape.getPart().isChanneled() || !this.components.stream().anyMatch(c -> !((Component)c.getPart()).canBeChanneled());
    }

    public int getMaxChannelTime() {
        if (!this.isValid()) {
            return 0;
        }
        Shape s = (Shape)((ModifiedSpellPart)this.getShape()).getPart();
        return s.isChanneled() ? s.maxChannelTime(this.getShape()) : 0;
    }

    public boolean isChanneled() {
        if (!this.isValid()) {
            return false;
        }
        return ((Shape)((ModifiedSpellPart)this.getShape()).getPart()).isChanneled();
    }

    public boolean isMysterious() {
        return this.isMysterious;
    }

    public void setMysterious(boolean mysterious) {
        this.isMysterious = mysterious;
    }

    public void setOverrideAffinity(Affinity affinity) {
        this.overrideAffinity = affinity;
    }

    public boolean hasOverrideAffinity() {
        return this.overrideAffinity != Affinity.UNKNOWN;
    }

    public boolean hasOverrideManaCost() {
        return this.overrideManaCost >= 0.0f;
    }

    public boolean canFactionCraft(IPlayerProgression progression) {
        int i;
        if (((Shape)((ModifiedSpellPart)this.getShape()).getPart()).getFactionRequirement() != Faction.NONE && ((Shape)((ModifiedSpellPart)this.getShape()).getPart()).getFactionRequirement() != progression.getAlliedFaction()) {
            return false;
        }
        for (i = 0; i < 5; ++i) {
            IModifiedSpellPart c = this.getComponent(i);
            if (c == null || ((Component)((ModifiedSpellPart)c).getPart()).getFactionRequirement() == Faction.NONE || ((Component)((ModifiedSpellPart)c).getPart()).getFactionRequirement() == progression.getAlliedFaction()) continue;
            return false;
        }
        for (i = 0; i < 3; ++i) {
            Modifier m = this.getModifier(i);
            if (m == null || m.getFactionRequirement() == Faction.NONE || m.getFactionRequirement() == progression.getAlliedFaction()) continue;
            return false;
        }
        return true;
    }

    public boolean changeShapeAttributeValue(Attribute attribute, float newValue) {
        if (this.shape == null) {
            return false;
        }
        this.shape.setValue(attribute, newValue);
        this.recalculateSpellNumbers();
        return true;
    }

    public boolean changeComponentAttributeValue(int index, Attribute attribute, float newValue) {
        if (index < 0 || index >= this.components.size() || this.components.get(index) == null) {
            return false;
        }
        this.components.get(index).setValue(attribute, newValue);
        this.recalculateSpellNumbers();
        return true;
    }

    @Override
    public void writeToNBT(CompoundNBT nbt) {
        CompoundNBT spell = new CompoundNBT();
        if (this.getShape() != null) {
            spell.func_218657_a("shape", (INBT)((ModifiedSpellPart)this.getShape()).toNBT());
        }
        ListNBT componentData = new ListNBT();
        for (ModifiedSpellPart<Component> component : this.components) {
            if (component == null) continue;
            componentData.add((Object)component.toNBT());
        }
        spell.func_218657_a("components", (INBT)componentData);
        CompoundNBT modifierNBT = new CompoundNBT();
        for (int i = 0; i < 3; ++i) {
            if (this.getModifier(i) == null) {
                modifierNBT.func_74778_a("modifier_" + i, ManaAndArtifice.EMPTY.toString());
                continue;
            }
            modifierNBT.func_74778_a("modifier_" + i, this.getModifier(i).getRegistryName().toString());
        }
        spell.func_218657_a("modifiers", (INBT)modifierNBT);
        spell.func_74757_a("mysterious", this.isMysterious());
        spell.func_74778_a("overrideAffinity", this.overrideAffinity.toString());
        if (this.hasOverrideManaCost()) {
            spell.func_74776_a("overrideManaCost", this.overrideManaCost);
        }
        nbt.func_218657_a(SPELL_COMPOUND_TAG, (INBT)spell);
    }

    public static SpellRecipe fromNBT(CompoundNBT nbt) {
        SpellRecipe recipe = new SpellRecipe();
        if (nbt == null) {
            return recipe;
        }
        if (nbt.func_74764_b(SPELL_COMPOUND_TAG)) {
            nbt = nbt.func_74775_l(SPELL_COMPOUND_TAG);
        }
        if (nbt.func_74764_b("shape")) {
            recipe.shape = ModifiedSpellPart.fromNBT(nbt.func_74775_l("shape"), Registries.Shape);
        }
        if (nbt.func_74764_b("component")) {
            recipe.components.clear();
            recipe.components.add(ModifiedSpellPart.fromNBT(nbt.func_74775_l("component"), Registries.Component));
        } else if (nbt.func_74764_b("components")) {
            ListNBT ComponentData = nbt.func_150295_c("components", 10);
            for (INBT cINBT : ComponentData) {
                ModifiedSpellPart<Component> comp;
                if (!(cINBT instanceof CompoundNBT) || (comp = ModifiedSpellPart.fromNBT((CompoundNBT)cINBT, Registries.Component)) == null) continue;
                recipe.components.add(comp);
            }
        }
        if (nbt.func_74764_b("modifiers")) {
            CompoundNBT modifierNBT = nbt.func_74775_l("modifiers");
            for (int i = 0; i < 3; ++i) {
                ResourceLocation rLoc = new ResourceLocation(modifierNBT.func_74779_i("modifier_" + i));
                recipe.modifiers[i] = (Modifier)Registries.Modifier.getValue(rLoc);
            }
        }
        if (nbt.func_74764_b("mysterious")) {
            recipe.isMysterious = nbt.func_74767_n("mysterious");
        }
        if (nbt.func_74764_b("overrideAffinity")) {
            recipe.overrideAffinity = Affinity.valueOf(nbt.func_74779_i("overrideAffinity"));
        }
        if (nbt.func_74764_b("overrideManaCost")) {
            recipe.overrideManaCost = nbt.func_74760_g("overrideManaCost");
        }
        recipe.recalculateSpellNumbers();
        return recipe;
    }

    public static boolean stackContainsSpell(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return false;
        }
        CompoundNBT tag = stack.func_77978_p();
        if (tag.func_74764_b(SPELL_COMPOUND_TAG)) {
            CompoundNBT subTag = tag.func_74775_l(SPELL_COMPOUND_TAG);
            return subTag.func_74764_b("shape") && (subTag.func_74764_b("component") || subTag.func_74764_b("components"));
        }
        return false;
    }

    public void calculateComplexity() {
        this.complexity = 0.0f;
        if (this.shape != null) {
            this.complexity += this.shape.getPart().initialComplexity();
            for (Attribute attr : this.shape.getContainedAttributes()) {
                float modifiedValue = this.shape.getValue(attr);
                float modificationTotal = Math.abs(modifiedValue - this.shape.getDefaultValue(attr));
                this.complexity += (float)((int)Math.ceil(modificationTotal / this.shape.getStep(attr))) * this.shape.getStepComplexity(attr);
            }
        }
        for (ModifiedSpellPart<Component> component : this.components) {
            if (component == null) continue;
            this.complexity += component.getPart().initialComplexity();
            for (Attribute attr : component.getContainedAttributes()) {
                float modifiedValue = component.getValue(attr);
                float modificationTotal = Math.abs(modifiedValue - component.getDefaultValue(attr));
                this.complexity += (float)((int)Math.ceil(modificationTotal / component.getStep(attr))) * component.getStepComplexity(attr);
            }
        }
    }

    public void calculateManaCost() {
        this.overrideManaCost = -1.0f;
        this.calculatedManaCost = this.complexity * 1.5f;
    }

    @Override
    public int getTier(@Nonnull World world) {
        Optional shape_recipe;
        int tier = 1;
        if (this.shape != null && (shape_recipe = world.func_199532_z().func_215367_a(this.shape.getPart().getRegistryName())).isPresent()) {
            tier = Math.max(tier, ((ShapeRecipe)shape_recipe.get()).getTier());
        }
        for (ModifiedSpellPart<Component> component : this.components) {
            Optional component_recipe;
            if (component == null || !(component_recipe = world.func_199532_z().func_215367_a(component.getPart().getRegistryName())).isPresent()) continue;
            tier = Math.max(tier, ((ComponentRecipe)component_recipe.get()).getTier());
        }
        for (Modifier modifier : this.modifiers) {
            Optional mod_recipe;
            if (modifier == null || !(mod_recipe = world.func_199532_z().func_215367_a(modifier.getRegistryName())).isPresent()) continue;
            tier = Math.max(tier, ((ModifierRecipe)mod_recipe.get()).getTier());
        }
        return tier;
    }

    @Override
    public HashMap<Affinity, Float> getAffinity() {
        HashMap<Affinity, Float> affinityMap = new HashMap<Affinity, Float>();
        if (this.hasOverrideAffinity()) {
            affinityMap.put(this.overrideAffinity, Float.valueOf(1.0f));
            return affinityMap;
        }
        float total = 0.0f;
        HashMap<Affinity, Integer> affinityCount = new HashMap<Affinity, Integer>();
        for (ModifiedSpellPart<Component> component : this.components) {
            if (component == null) continue;
            total += 1.0f;
            Affinity aff = component.getPart().getAffinity();
            if (!affinityCount.containsKey((Object)aff)) {
                affinityCount.put(aff, 1);
                continue;
            }
            affinityCount.put(aff, (Integer)affinityCount.get((Object)aff) + 1);
        }
        for (Affinity aff : affinityCount.keySet()) {
            affinityMap.put(aff, Float.valueOf((float)((Integer)affinityCount.get((Object)aff)).intValue() / total));
        }
        if (affinityMap.size() == 0) {
            affinityMap.put(Affinity.UNKNOWN, Float.valueOf(1.0f));
        }
        return affinityMap;
    }

    @Override
    public Affinity getHighestAffinity() {
        return (Affinity)((Object)Collections.max(this.getAffinity().entrySet(), Comparator.comparingDouble(Map.Entry::getValue)).getKey());
    }

    public NonNullList<ResourceLocation> getReagentsForComplexity() {
        NonNullList complexityReagents = NonNullList.func_191196_a();
        int c = (int)Math.ceil(this.complexity);
        for (int i = 0; i < 4 && (c -= this.addLargestComplexityReagent((NonNullList<ResourceLocation>)complexityReagents, c, i == 3)) > 0; ++i) {
        }
        return complexityReagents;
    }

    public void maximize() {
        if (this.shape != null) {
            this.shape.getContainedAttributes().forEach(a -> this.shape.setValue((Attribute)((Object)a), this.shape.getMaximumValue((Attribute)((Object)a))));
        }
        this.components.forEach((Consumer<ModifiedSpellPart<Component>>)((Consumer<ModifiedSpellPart>)c -> c.getContainedAttributes().forEach(a -> c.setValue((Attribute)((Object)((Object)a)), this.shape.getMaximumValue((Attribute)((Object)((Object)a)))))));
        this.recalculateSpellNumbers();
    }

    @Override
    public List<SpellReagent> getReagents(@Nullable PlayerEntity caster, @Nullable SpellCastingResult spellResult) {
        ArrayList<SpellReagent> reagents = new ArrayList<SpellReagent>();
        List<SpellReagent> shape_reagents = ((Shape)((ModifiedSpellPart)this.getShape()).getPart()).getRequiredReagents(caster);
        if (shape_reagents != null) {
            reagents.addAll(shape_reagents);
        }
        for (int i = 0; i < this.components.size(); ++i) {
            List<SpellReagent> component_reagents;
            Component c = (Component)((ModifiedSpellPart)this.getComponent(i)).getPart();
            if (spellResult != null && spellResult.getResultFor(c) != ComponentApplicationResult.SUCCESS && spellResult.getResultFor(c) != ComponentApplicationResult.DELAYED && spellResult.getResultFor(c) != ComponentApplicationResult.TARGET_ENTITY_SPAWNED || (component_reagents = c.getRequiredReagents(caster)) == null) continue;
            reagents.addAll(component_reagents);
        }
        return reagents;
    }

    private int addLargestComplexityReagent(NonNullList<ResourceLocation> list, int complexity, boolean mustContain) {
        if (mustContain) {
            if (complexity <= LESSER_FOCUS_COMPLEXITY) {
                list.add((Object)ItemInit.RITUAL_FOCUS_LESSER.getId());
                return LESSER_FOCUS_COMPLEXITY;
            }
            list.add((Object)ItemInit.RITUAL_FOCUS_GREATER.getId());
            return GREATER_FOCUS_COMPLEXITY;
        }
        if (complexity <= MINOR_FOCUS_COMPLEXITY * 3) {
            list.add((Object)ItemInit.RITUAL_FOCUS_MINOR.getId());
            return MINOR_FOCUS_COMPLEXITY;
        }
        if (complexity < LESSER_FOCUS_COMPLEXITY * 3) {
            list.add((Object)ItemInit.RITUAL_FOCUS_LESSER.getId());
            return LESSER_FOCUS_COMPLEXITY;
        }
        list.add((Object)ItemInit.RITUAL_FOCUS_GREATER.getId());
        return GREATER_FOCUS_COMPLEXITY;
    }

    public void writeRecipeForRitual(World world, CompoundNBT nbt) {
        ComponentRecipe componentRecipe;
        ModifiedSpellPart<Component> component;
        ShapeRecipe shapeRecipe;
        if (this.components.size() != 1) {
            return;
        }
        CompoundNBT ritualReagentData = new CompoundNBT();
        NonNullList patterns = NonNullList.func_191196_a();
        if (this.shape != null && (shapeRecipe = ItemAndPatternRecipeHelper.GetRecipe(world, this.shape.getPart().getRegistryName(), RecipeInit.SHAPE_TYPE)) != null) {
            this.WriteRLocList(ritualReagentData, Arrays.asList(shapeRecipe.getRequiredItems()), "shape_items");
            for (ResourceLocation rLoc : shapeRecipe.getRequiredPatterns()) {
                patterns.add((Object)rLoc);
            }
        }
        if ((component = this.components.get(0)) != null && (componentRecipe = ItemAndPatternRecipeHelper.GetRecipe(world, component.getPart().getRegistryName(), RecipeInit.COMPONENT_TYPE)) != null) {
            this.WriteRLocList(ritualReagentData, Arrays.asList(componentRecipe.getRequiredItems()), "component_items");
            for (ResourceLocation rLoc : componentRecipe.getRequiredPatterns()) {
                patterns.add((Object)rLoc);
            }
        }
        for (int i = 0; i < this.modifiers.length; ++i) {
            ModifierRecipe modifierRecipe;
            if (this.modifiers[i] == null || (modifierRecipe = ItemAndPatternRecipeHelper.GetRecipe(world, this.modifiers[i].getRegistryName(), RecipeInit.MODIFIER_TYPE)) == null) continue;
            this.WriteRLocList(ritualReagentData, Arrays.asList(modifierRecipe.getRequiredItems()), "modifier_" + i + "_items");
            for (ResourceLocation rLoc : modifierRecipe.getRequiredPatterns()) {
                patterns.add((Object)rLoc);
            }
        }
        this.WriteRLocList(ritualReagentData, (Collection<ResourceLocation>)patterns, "pattern");
        this.WriteRLocList(ritualReagentData, (Collection<ResourceLocation>)this.getReagentsForComplexity(), "complexity_reagent");
        nbt.func_218657_a("ritual_reagent_data", (INBT)ritualReagentData);
    }

    private void WriteRLocList(CompoundNBT nbt, Collection<ResourceLocation> list, String prefix) {
        if (list.size() == 0) {
            return;
        }
        int count = 0;
        nbt.func_74768_a(prefix + "_count", list.size());
        for (ResourceLocation rLoc : list) {
            nbt.func_74778_a(prefix + "_" + count++, rLoc.toString());
        }
    }

    private static NonNullList<ResourceLocation> ReadRLocList(CompoundNBT nbt, String prefix) {
        NonNullList rLocs = NonNullList.func_191196_a();
        if (!nbt.func_74764_b(prefix + "_count")) {
            return rLocs;
        }
        int count = nbt.func_74762_e(prefix + "_count");
        for (int i = 0; i < count; ++i) {
            String key = prefix + "_" + i;
            if (nbt.func_74764_b(key)) {
                rLocs.add((Object)new ResourceLocation(nbt.func_74779_i(key)));
                continue;
            }
            ManaAndArtifice.LOGGER.error("Failed to read key '" + key + "' from dynamic ritual spell recipe NBT (not found).");
        }
        return rLocs;
    }

    public static boolean isReagentContainer(ItemStack recipeStack) {
        CompoundNBT nbt = recipeStack.func_77978_p();
        return nbt != null && nbt.func_74764_b("ritual_reagent_data");
    }

    public static NonNullList<ResourceLocation> getShapeReagents(ItemStack recipeStack) {
        CompoundNBT ritualReagentData = recipeStack.func_190925_c("ritual_reagent_data");
        return SpellRecipe.ReadRLocList(ritualReagentData, "shape_items");
    }

    public static NonNullList<ResourceLocation> getComponentReagents(ItemStack recipeStack) {
        CompoundNBT ritualReagentData = recipeStack.func_190925_c("ritual_reagent_data");
        return SpellRecipe.ReadRLocList(ritualReagentData, "component_items");
    }

    public static NonNullList<ResourceLocation> getModifierReagents(ItemStack recipeStack, int modifierIndex) {
        CompoundNBT ritualReagentData = recipeStack.func_190925_c("ritual_reagent_data");
        return SpellRecipe.ReadRLocList(ritualReagentData, "modifier_" + modifierIndex + "_items");
    }

    public static NonNullList<ResourceLocation> getComplexityReagents(ItemStack recipeStack) {
        CompoundNBT ritualReagentData = recipeStack.func_190925_c("ritual_reagent_data");
        return SpellRecipe.ReadRLocList(ritualReagentData, "complexity_reagent");
    }

    public static NonNullList<ResourceLocation> getPatterns(ItemStack recipeStack) {
        CompoundNBT ritualReagentData = recipeStack.func_190925_c("ritual_reagent_data");
        return SpellRecipe.ReadRLocList(ritualReagentData, "pattern");
    }
}

