/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.shapes;

import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.parts.Shape;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.api.spells.targeting.SpellTargetHelper;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class ShapeRaytrace
extends Shape {
    public ShapeRaytrace(float range, float maxRange, ResourceLocation registryName, ResourceLocation icon) {
        super(registryName, icon, new AttributeValuePair(Attribute.RANGE, range, range, maxRange, 1.0f));
    }

    public ShapeRaytrace(ResourceLocation registryName, ResourceLocation icon, AttributeValuePair ... attributes) {
        super(registryName, icon, attributes);
    }

    @Override
    public SpellTarget Target(SpellSource source, World world, IModifiedSpellPart<Shape> modificationData, ISpellDefinition recipe) {
        if (source == null) {
            return SpellTarget.NONE;
        }
        float range = modificationData.getValue(Attribute.RANGE);
        RayTraceResult targetResult = SpellTargetHelper.rayTrace((Entity)source.getCaster(), world, source.getOrigin(), source.getForward(), true, false, RayTraceContext.BlockMode.OUTLINE, entity -> entity.func_70067_L() && entity.func_70089_S() && entity != source.getCaster(), source.getBoundingBox().func_72314_b((double)range, (double)range, (double)range), range);
        RayTraceResult.Type targetType = targetResult.func_216346_c();
        if (targetType == RayTraceResult.Type.MISS) {
            return SpellTarget.NONE;
        }
        return targetType == RayTraceResult.Type.BLOCK ? new SpellTarget(((BlockRayTraceResult)targetResult).func_216350_a(), ((BlockRayTraceResult)targetResult).func_216354_b()) : new SpellTarget(((EntityRayTraceResult)targetResult).func_216348_a());
    }

    @Override
    public float initialComplexity() {
        return 5.0f;
    }

    @Override
    public int requiredXPForRote() {
        return 500;
    }
}

