/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.shapes;

import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.parts.Shape;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.entities.sorcery.targeting.EntitySpellRune;
import com.ma.spells.shapes.ShapeRaytrace;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ShapeRune
extends ShapeRaytrace {
    public ShapeRune(ResourceLocation registryName, ResourceLocation guiIcon) {
        super(registryName, guiIcon, new AttributeValuePair(Attribute.RADIUS, 1.0f, 1.0f, 3.0f, 1.0f, 5.0f), new AttributeValuePair(Attribute.MAGNITUDE, 1.0f, 1.0f, 3.0f, 1.0f, 5.0f), new AttributeValuePair(Attribute.RANGE, 3.0f, 3.0f, 16.0f, 1.0f, 3.0f));
    }

    @Override
    public SpellTarget Target(SpellSource source, World world, IModifiedSpellPart<Shape> modificationData, ISpellDefinition recipe) {
        if (!source.isPlayerCaster()) {
            return SpellTarget.NONE;
        }
        SpellTarget tgt = super.Target(source, world, modificationData, recipe);
        if (tgt == SpellTarget.NONE || tgt.isEntity()) {
            return SpellTarget.NONE;
        }
        if (!world.field_72995_K) {
            EntitySpellRune rune = new EntitySpellRune(source.getPlayer(), recipe);
            BlockPos pos = tgt.getBlock().func_177972_a(tgt.getBlockFace(null));
            if (world.func_217357_a(Entity.class, new AxisAlignedBB(pos)).size() != 0) {
                return SpellTarget.NONE;
            }
            rune.func_70107_b((float)pos.func_177958_n() + 0.5f, (double)pos.func_177956_o() + 0.01, (float)pos.func_177952_p() + 0.5f);
            world.func_217376_c((Entity)rune);
        }
        return new SpellTarget((Entity)source.getPlayer());
    }

    @Override
    public boolean spawnsTargetEntity() {
        return true;
    }

    @Override
    public float initialComplexity() {
        return 20.0f;
    }

    @Override
    public int requiredXPForRote() {
        return 250;
    }
}

