/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.shapes;

import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.parts.Shape;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.entities.sorcery.targeting.EntitySpellSmite;
import com.ma.spells.shapes.ShapeRaytrace;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class ShapeSmite
extends ShapeRaytrace {
    public ShapeSmite(ResourceLocation registryName, ResourceLocation guiIcon) {
        super(registryName, guiIcon, new AttributeValuePair(Attribute.RADIUS, 1.0f, 1.0f, 5.0f, 0.5f, 3.0f), new AttributeValuePair(Attribute.RANGE, 8.0f, 8.0f, 32.0f, 1.0f, 2.0f), new AttributeValuePair(Attribute.HEIGHT, 1.0f, 1.0f, 3.0f, 0.5f, 3.0f));
    }

    @Override
    public SpellTarget Target(SpellSource source, World world, IModifiedSpellPart<Shape> modificationData, ISpellDefinition recipe) {
        if (!source.isPlayerCaster()) {
            return SpellTarget.NONE;
        }
        SpellTarget tgt = super.Target(source, world, modificationData, recipe);
        if (tgt == SpellTarget.NONE) {
            return tgt;
        }
        if (!world.field_72995_K) {
            Vector3d position = null;
            if (tgt.isBlock()) {
                BlockPos blockPos = tgt.getBlock().func_177972_a(tgt.getBlockFace(null));
                position = new Vector3d((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5);
            } else if (tgt.isEntity()) {
                position = tgt.getEntity().func_213303_ch();
            }
            int count = 0;
            BlockPos targetPos = new BlockPos(position);
            while (count < 15) {
                if (!world.func_175623_d(targetPos)) {
                    return SpellTarget.NONE;
                }
                ++count;
                targetPos = targetPos.func_177984_a();
            }
            position = position.func_72441_c(0.0, 15.0, 0.0);
            CompoundNBT recipeData = new CompoundNBT();
            recipe.writeToNBT(recipeData);
            EntitySpellSmite projectile = new EntitySpellSmite(world, position, recipeData, (LivingEntity)source.getPlayer());
            world.func_217376_c((Entity)projectile);
            return new SpellTarget((Entity)projectile);
        }
        return SpellTarget.NONE;
    }

    @Override
    public boolean spawnsTargetEntity() {
        return true;
    }

    @Override
    public float initialComplexity() {
        return 20.0f;
    }

    @Override
    public int requiredXPForRote() {
        return 500;
    }
}

