/*
 * Decompiled with CFR 0.152.
 */
package com.ma.tools;

import com.ma.tools.LootUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.dispenser.IPosition;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class BlockUtils {
    public static boolean placeBlock(ServerWorld world, BlockPos pos, Direction face, BlockState state, @Nullable PlayerEntity player) {
        if (world.func_195588_v(pos) && !ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)BlockSnapshot.create((RegistryKey)world.func_234923_W_(), (IWorld)world, (BlockPos)pos), (Direction)face)) {
            world.func_175656_a(pos, state);
            return true;
        }
        return false;
    }

    public static BlockPos[] getBlocksInFrontOfCharacter(LivingEntity entity, int numBlocks, BlockPos firstBlock) {
        float speed = 0.1f;
        float factor = (float)Math.PI / 180;
        float sinYawRadians = MathHelper.func_76126_a((float)(entity.field_70177_z * factor));
        float cosYawRadians = MathHelper.func_76134_b((float)(entity.field_70177_z * factor));
        float sinPitchRadians = MathHelper.func_76126_a((float)(entity.field_70125_A * factor));
        float cosPitchRadians = MathHelper.func_76134_b((float)(entity.field_70125_A * factor));
        double motionZ = cosYawRadians * cosPitchRadians * speed;
        double motionX = -sinYawRadians * cosPitchRadians * speed;
        double motionY = -sinPitchRadians * speed;
        double curX = firstBlock.func_177958_n();
        double curY = firstBlock.func_177956_o();
        double curZ = firstBlock.func_177952_p();
        float minimum = 0.01f;
        if (Math.abs(motionX) < (double)minimum) {
            motionX = 0.0;
        }
        if (Math.abs(motionY) < (double)minimum) {
            motionY = 0.0;
        }
        if (Math.abs(motionZ) < (double)minimum) {
            motionZ = 0.0;
        }
        int lastX = firstBlock.func_177958_n();
        int lastY = firstBlock.func_177956_o();
        int lastZ = firstBlock.func_177952_p();
        BlockPos[] list = new BlockPos[numBlocks];
        list[0] = new BlockPos((Vector3i)firstBlock);
        int count = 1;
        while (count < numBlocks) {
            if ((int)Math.round(curX += motionX) == lastX && (int)Math.round(curY += motionY) == lastY && (int)Math.round(curZ += motionZ) == lastZ) continue;
            lastX = (int)Math.round(curX);
            lastY = (int)Math.round(curY);
            lastZ = (int)Math.round(curZ);
            list[count++] = new BlockPos(lastX, lastY, lastZ);
        }
        return list;
    }

    public static void stepThroughBlocksLinear(BlockPos a, BlockPos b, Consumer<BlockPos> action) {
        float stepDist = 0.2f;
        Vector3d curPos = Vector3d.func_237489_a_((Vector3i)a);
        Vector3d endPos = Vector3d.func_237489_a_((Vector3i)b);
        Vector3d step = endPos.func_178788_d(curPos).func_72432_b().func_186678_a((double)stepDist);
        action.accept(new BlockPos(curPos.func_82615_a(), curPos.func_82617_b(), curPos.func_82616_c()));
        while (!curPos.func_237488_a_((IPosition)endPos, (double)stepDist)) {
            curPos = curPos.func_178787_e(step);
            BlockPos cbp = new BlockPos(curPos.func_82615_a(), curPos.func_82617_b(), curPos.func_82616_c());
            action.accept(cbp);
        }
    }

    public static BlockPos Vector3dToBlockPosRound(Vector3d vec) {
        return new BlockPos((double)Math.round(vec.field_72450_a), (double)Math.round(vec.field_72448_b), (double)Math.round(vec.field_72449_c));
    }

    public static void stepThroughBlocksInCube(Vector3d a, Vector3d b, Consumer<BlockPos> action) {
        Vector3d dimensions = b.func_178788_d(a);
        Vector3d step = dimensions.func_72432_b();
        ArrayList<BlockPos> processed = new ArrayList<BlockPos>();
        double x = a.field_72450_a;
        while (b.field_72450_a - x > step.field_72450_a) {
            double y = a.field_72448_b;
            while (b.field_72448_b - y > step.field_72448_b) {
                double z = a.field_72449_c;
                while (b.field_72449_c - z > step.field_72449_c) {
                    BlockPos cur = BlockUtils.Vector3dToBlockPosRound(new Vector3d(x, y, z));
                    if (!processed.contains(cur)) {
                        action.accept(cur);
                        processed.add(cur);
                    }
                    z += step.field_72449_c;
                }
                y += step.field_72448_b;
            }
            x += step.field_72450_a;
        }
    }

    public static boolean destroyBlock(LivingEntity caster, World world, BlockPos pos, boolean doDrops, int harvestLevel, ToolType ... tools) {
        return BlockUtils.destroyBlock(caster, world, pos, doDrops, false, -1, harvestLevel, tools);
    }

    public static boolean destroyBlock(LivingEntity caster, World world, BlockPos pos, boolean doDrops, boolean silkTouch, int fortuneLevel, int harvestLevel, ToolType ... tools) {
        if (!(world instanceof ServerWorld)) {
            return false;
        }
        PlayerEntity playerEntity = caster instanceof PlayerEntity ? (PlayerEntity)caster : FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world));
        BlockState state = world.func_180495_p(pos);
        float hardness = state.func_185887_b((IBlockReader)world, pos);
        if (state.getHarvestLevel() > harvestLevel || hardness < 0.0f) {
            return false;
        }
        if (state.func_235783_q_() && state.getHarvestTool() != null) {
            boolean toolFound = false;
            for (ToolType type : tools) {
                if (type != state.getHarvestTool()) continue;
                toolFound = true;
                break;
            }
            if (!toolFound) {
                return false;
            }
        }
        TileEntity te = world.func_175625_s(pos);
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, playerEntity);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        if (fortuneLevel > 0) {
            ItemStack stack = LootUtils.createDummyTool();
            stack.func_77966_a(Enchantments.field_185308_t, fortuneLevel);
            Block.func_220054_a((BlockState)world.func_180495_p(pos), (World)world, (BlockPos)pos, (TileEntity)world.func_175625_s(pos), (Entity)playerEntity, (ItemStack)stack);
        } else if (silkTouch) {
            ItemStack stack = LootUtils.createDummyTool();
            stack.func_77966_a(Enchantments.field_185306_r, 1);
            Block.func_220054_a((BlockState)world.func_180495_p(pos), (World)world, (BlockPos)pos, (TileEntity)world.func_175625_s(pos), (Entity)playerEntity, (ItemStack)stack);
        }
        int xp = state.getExpDrop((IWorldReader)world, pos, 0, 0);
        if (xp > 0) {
            state.func_177230_c().func_180637_b((ServerWorld)world, pos, xp);
        }
        if (world.func_225521_a_(pos, false, (Entity)caster)) {
            if (doDrops) {
                state.func_177230_c().func_180657_a(world, playerEntity, pos, state, te, ItemStack.field_190927_a);
            }
            BlockUtils.updateBlockState(world, pos);
            return true;
        }
        return false;
    }

    public static List<ItemStack> destroyBlockCaptureDrops(LivingEntity caster, World world, BlockPos pos, boolean silkTouch, int fortuneLevel, int harvestLevel, ToolType ... tools) {
        BlockEvent.BreakEvent event;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (!(world instanceof ServerWorld)) {
            return drops;
        }
        PlayerEntity playerEntity = caster instanceof PlayerEntity ? (PlayerEntity)caster : FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world));
        BlockState state = world.func_180495_p(pos);
        float hardness = state.func_185887_b((IBlockReader)world, pos);
        if (state.getHarvestLevel() > harvestLevel || hardness < 0.0f) {
            return drops;
        }
        if (state.func_235783_q_() && state.getHarvestTool() != null) {
            boolean toolFound = false;
            for (ToolType type : tools) {
                if (type != state.getHarvestTool()) continue;
                toolFound = true;
                break;
            }
            if (!toolFound) {
                return drops;
            }
        }
        if (MinecraftForge.EVENT_BUS.post((Event)(event = new BlockEvent.BreakEvent(world, pos, state, playerEntity)))) {
            return drops;
        }
        if (world.func_225521_a_(pos, false, (Entity)caster)) {
            ItemStack stack;
            if (fortuneLevel > 0) {
                stack = LootUtils.createDummyTool();
                stack.func_77966_a(Enchantments.field_185308_t, fortuneLevel);
                drops.addAll(Block.func_220077_a((BlockState)state, (ServerWorld)((ServerWorld)world), (BlockPos)pos, (TileEntity)world.func_175625_s(pos), (Entity)playerEntity, (ItemStack)stack));
            } else if (silkTouch) {
                stack = LootUtils.createDummyTool();
                stack.func_77966_a(Enchantments.field_185306_r, 1);
                drops.addAll(Block.func_220077_a((BlockState)state, (ServerWorld)((ServerWorld)world), (BlockPos)pos, (TileEntity)world.func_175625_s(pos), (Entity)playerEntity, (ItemStack)stack));
            } else {
                drops.addAll(Block.func_220077_a((BlockState)state, (ServerWorld)((ServerWorld)world), (BlockPos)pos, (TileEntity)world.func_175625_s(pos), (Entity)playerEntity, (ItemStack)ItemStack.field_190927_a));
            }
            int xp = state.getExpDrop((IWorldReader)world, pos, 0, 0);
            if (xp > 0) {
                state.func_177230_c().func_180637_b((ServerWorld)world, pos, xp);
            }
            BlockUtils.updateBlockState(world, pos);
        }
        return drops;
    }

    public static boolean canDestroyBlock(LivingEntity caster, World world, BlockPos pos, int harvestLevel, ToolType ... tools) {
        BlockEvent.BreakEvent event;
        if (!(world instanceof ServerWorld)) {
            return false;
        }
        PlayerEntity playerEntity = caster instanceof PlayerEntity ? (PlayerEntity)caster : FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world));
        BlockState state = world.func_180495_p(pos);
        float hardness = state.func_185887_b((IBlockReader)world, pos);
        if (state.getHarvestLevel() > harvestLevel || hardness < 0.0f) {
            return false;
        }
        if (state.func_235783_q_() && state.getHarvestTool() != null) {
            boolean toolFound = false;
            for (ToolType type : tools) {
                if (type != state.getHarvestTool()) continue;
                toolFound = true;
                break;
            }
            if (!toolFound) {
                return false;
            }
        }
        return !MinecraftForge.EVENT_BUS.post((Event)(event = new BlockEvent.BreakEvent(world, pos, state, playerEntity)));
    }

    public static void updateBlockState(World world, BlockPos pos, BlockState state) {
        if (!World.func_189509_E((BlockPos)pos)) {
            world.func_184138_a(pos, state, state, 3);
        }
    }

    public static void updateBlockState(World world, BlockPos pos) {
        BlockUtils.updateBlockState(world, pos, world.func_180495_p(pos));
    }

    public static boolean tryDestroyBlockSilent(World world, BlockPos pos, boolean dropBlock) {
        return BlockUtils.destroyBlockSilent(world, pos, dropBlock, null);
    }

    public static boolean tryDestroyBlockSilent(World world, BlockPos pos, boolean dropBlock, @Nullable LivingEntity caster) {
        PlayerEntity playerEntity;
        if (!(world instanceof ServerWorld)) {
            return false;
        }
        Object object = playerEntity = caster instanceof PlayerEntity ? (PlayerEntity)caster : FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world));
        if (MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(world, pos, world.func_180495_p(pos), playerEntity))) {
            return false;
        }
        return BlockUtils.destroyBlockSilent(world, pos, dropBlock);
    }

    private static boolean destroyBlockSilent(World world, BlockPos pos, boolean dropBlock) {
        return BlockUtils.destroyBlockSilent(world, pos, dropBlock, null);
    }

    private static boolean destroyBlockSilent(World world, BlockPos pos, boolean isMoving, @Nullable Entity entityIn) {
        BlockState blockstate = world.func_180495_p(pos);
        if (world.func_175623_d(pos)) {
            return false;
        }
        FluidState ifluidstate = world.func_204610_c(pos);
        if (isMoving) {
            TileEntity tileentity = blockstate.hasTileEntity() ? world.func_175625_s(pos) : null;
            Block.func_220054_a((BlockState)blockstate, (World)world, (BlockPos)pos, (TileEntity)tileentity, (Entity)entityIn, (ItemStack)ItemStack.field_190927_a);
        }
        return world.func_180501_a(pos, ifluidstate.func_206883_i(), 3);
    }
}

