/*
 * Decompiled with CFR 0.152.
 */
package com.ma.tools;

import com.ma.tools.MATags;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;

public class InventoryUtilities {
    public static boolean mergeIntoInventory(IItemHandler handler, ItemStack toMerge) {
        return InventoryUtilities.mergeIntoInventory(handler, toMerge, toMerge.func_190916_E());
    }

    public static boolean mergeIntoInventory(IItemHandler handler, ItemStack toMerge, int quantity) {
        if (quantity > toMerge.func_190916_E()) {
            quantity = toMerge.func_190916_E();
        }
        int emptySlot = -1;
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (!handler.isItemValid(i, toMerge)) continue;
            ItemStack inventoryStack = handler.getStackInSlot(i);
            if (inventoryStack.func_190926_b()) {
                if (emptySlot != -1) continue;
                emptySlot = i;
                continue;
            }
            if (!inventoryStack.func_77969_a(toMerge) || inventoryStack.func_190916_E() >= handler.getSlotLimit(i)) continue;
            int spaceAvailable = handler.getSlotLimit(i) - inventoryStack.func_190916_E();
            ItemStack split = toMerge.func_77979_a(Math.min(quantity, spaceAvailable));
            handler.insertItem(i, split, false);
            if ((quantity -= split.func_190916_E()) > 0) continue;
            return true;
        }
        if (quantity > 0 && emptySlot > -1) {
            ItemStack insert = ItemStack.field_190927_a;
            int maxStackSize = handler.getSlotLimit(emptySlot);
            if (toMerge.func_190916_E() > maxStackSize) {
                insert = toMerge.func_77979_a(maxStackSize);
                insert = handler.insertItem(emptySlot, insert, false);
                toMerge.func_190920_e(toMerge.func_190916_E() + insert.func_190916_E());
            } else {
                toMerge = handler.insertItem(emptySlot, toMerge, false);
            }
            return true;
        }
        return false;
    }

    public static ItemStack getFirstItemFromContainer(List<Item> items, int maxCount, IItemHandler handler, Direction side) {
        return InventoryUtilities.getFirstItemFromContainer(items, maxCount, handler, side, false);
    }

    public static ItemStack getFirstItemFromContainer(List<Item> items, int maxCount, IItemHandler handler, Direction side, boolean simulate) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.func_190926_b() || items.size() != 0 && !items.contains(stack.func_77973_b())) continue;
            int count = Math.min(stack.func_190916_E(), maxCount);
            return handler.extractItem(i, count, simulate);
        }
        return ItemStack.field_190927_a;
    }

    public static boolean hasStackInInventory(ItemStack search, boolean ignoreDurability, boolean compareNBT, IInventory inventory) {
        int countToFind = search.func_190916_E();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            boolean equal;
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            boolean bl = equal = ignoreDurability ? ItemStack.func_185132_d((ItemStack)stack, (ItemStack)search) : ItemStack.func_179545_c((ItemStack)stack, (ItemStack)search);
            if (compareNBT) {
                equal &= ItemStack.func_77970_a((ItemStack)stack, (ItemStack)search);
            }
            if (!equal || (countToFind -= search.func_190916_E()) > 0) continue;
            return true;
        }
        return false;
    }

    public static boolean removeItemFromInventory(ItemStack search, boolean ignoreDurability, boolean compareNBT, IInventory inventory) {
        int countToRemove = search.func_190916_E();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            boolean equal;
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            boolean bl = equal = ignoreDurability ? ItemStack.func_185132_d((ItemStack)stack, (ItemStack)search) : ItemStack.func_179545_c((ItemStack)stack, (ItemStack)search);
            if (compareNBT) {
                equal &= ItemStack.func_77970_a((ItemStack)stack, (ItemStack)search);
            }
            if (!equal) continue;
            int removeQty = Math.min(countToRemove, stack.func_190916_E());
            stack.func_190918_g(removeQty);
            if ((countToRemove -= removeQty) > 0) continue;
            return true;
        }
        return false;
    }

    public static ItemStack removeSingleItemFromInventory(ResourceLocation search, IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b() || !MATags.isItemEqual(stack, search)) continue;
            return stack.func_77979_a(1);
        }
        return ItemStack.field_190927_a;
    }
}

