/*
 * Decompiled with CFR 0.152.
 */
package com.ma.tools.math;

import com.ma.tools.math.Vector3;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class MathUtilities {
    public static Vector3[] GetHorizontalBlocksInFrontOfCharacter(LivingEntity entity, int numBlocks, int x, int y, int z) {
        float speed = 0.1f;
        float factor = (float)Math.PI / 180;
        float sinYawRadians = MathHelper.func_76126_a((float)(entity.field_70177_z * factor));
        float cosYawRadians = MathHelper.func_76134_b((float)(entity.field_70177_z * factor));
        double motionZ = cosYawRadians * speed;
        double motionX = -sinYawRadians * speed;
        double curX = x;
        double curY = y;
        double curZ = z;
        float minimum = 0.01f;
        if (Math.abs(motionX) < (double)minimum) {
            motionX = 0.0;
        }
        if (Math.abs(motionZ) < (double)minimum) {
            motionZ = 0.0;
        }
        int lastX = x;
        int lastY = y;
        int lastZ = z;
        Vector3[] list = new Vector3[numBlocks];
        list[0] = new Vector3(x, y, z);
        int count = 1;
        while (count < numBlocks) {
            if ((int)Math.round(curX += motionX) == lastX && (int)Math.round(curY) == lastY && (int)Math.round(curZ += motionZ) == lastZ) continue;
            lastX = (int)Math.round(curX);
            lastY = (int)Math.round(curY);
            lastZ = (int)Math.round(curZ);
            list[count++] = new Vector3(lastX, lastY, lastZ);
        }
        return list;
    }

    public static Vector3[] GetBlocksInFrontOfCharacter(LivingEntity entity, int numBlocks, int x, int y, int z) {
        float speed = 0.1f;
        float factor = (float)Math.PI / 180;
        float sinYawRadians = MathHelper.func_76126_a((float)(entity.field_70177_z * factor));
        float cosYawRadians = MathHelper.func_76134_b((float)(entity.field_70177_z * factor));
        float sinPitchRadians = MathHelper.func_76126_a((float)(entity.field_70125_A * factor));
        float cosPitchRadians = MathHelper.func_76134_b((float)(entity.field_70125_A * factor));
        double motionZ = cosYawRadians * cosPitchRadians * speed;
        double motionX = -sinYawRadians * cosPitchRadians * speed;
        double motionY = -sinPitchRadians * speed;
        double curX = x;
        double curY = y;
        double curZ = z;
        float minimum = 0.01f;
        if (Math.abs(motionX) < (double)minimum) {
            motionX = 0.0;
        }
        if (Math.abs(motionY) < (double)minimum) {
            motionY = 0.0;
        }
        if (Math.abs(motionZ) < (double)minimum) {
            motionZ = 0.0;
        }
        int lastX = x;
        int lastY = y;
        int lastZ = z;
        Vector3[] list = new Vector3[numBlocks];
        list[0] = new Vector3(x, y, z);
        int count = 1;
        while (count < numBlocks) {
            if ((int)Math.round(curX += motionX) == lastX && (int)Math.round(curY += motionY) == lastY && (int)Math.round(curZ += motionZ) == lastZ) continue;
            lastX = (int)Math.round(curX);
            lastY = (int)Math.round(curY);
            lastZ = (int)Math.round(curZ);
            list[count++] = new Vector3(lastX, lastY, lastZ);
        }
        return list;
    }

    public static int getDistanceToGround(LivingEntity ent, World world) {
        int yCoordOffset = 0;
        int distance = 0;
        while (distance < 20 && !world.func_175623_d(ent.func_233580_cy_().func_177982_a(0, yCoordOffset, 0))) {
            ++distance;
            --yCoordOffset;
        }
        return distance;
    }

    public static Vector3d reflect(Vector3d incident, Vector3d reflectionNormal) {
        Vector3d rn = reflectionNormal.func_72432_b();
        Vector3d i = incident.func_72432_b();
        double scale = 2.0 * rn.func_72430_b(i);
        return rn.func_178788_d(i).func_186678_a(scale);
    }

    public static float[] colorIntToFloats(int color) {
        float[] colors = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
        return colors;
    }

    public static int colorFloatsToInt(float r, float g, float b) {
        return ((int)(r * 255.0f) << 16) + ((int)(g * 255.0f) << 8) + (int)(b * 255.0f);
    }

    public static float clamp(float val, float min, float max) {
        return Math.max(min, Math.min(max, val));
    }

    public static float clamp01(float val) {
        return MathUtilities.clamp(val, 0.0f, 1.0f);
    }

    public static int clamp(int val, int min, int max) {
        return Math.max(min, Math.min(max, val));
    }

    public static float lerpf(float start, float end, float t) {
        return start + (end - start) * t;
    }

    public static Vector3d lerpVector3d(Vector3d a, Vector3d b, float t) {
        Vector3d diff = b.func_178788_d(a);
        Vector3d scaled = diff.func_186678_a((double)t);
        return a.func_178787_e(scaled);
    }

    public static Vector3d bezierVector3d(Vector3d start, Vector3d end, Vector3d control_1, Vector3d control_2, float time) {
        if (time < 0.0f) {
            time = 0.0f;
        } else if (time > 1.0f) {
            time = 1.0f;
        }
        float one_minus_t = 1.0f - time;
        Vector3d retValue = new Vector3d(0.0, 0.0, 0.0);
        Vector3d[] terms = new Vector3d[]{start.func_186678_a((double)(one_minus_t * one_minus_t * one_minus_t)), control_1.func_186678_a((double)(3.0f * one_minus_t * one_minus_t * time)), control_2.func_186678_a((double)(3.0f * one_minus_t * time * time)), end.func_186678_a((double)(time * time * time))};
        for (int i = 0; i < 4; ++i) {
            retValue = retValue.func_178787_e(terms[i]);
        }
        return retValue;
    }

    public static AxisAlignedBB createInclusiveBB(BlockPos a, BlockPos b) {
        AxisAlignedBB bb = new AxisAlignedBB(a, b).func_72321_a(1.0, 1.0, 1.0);
        return bb;
    }
}

