/*
 * Decompiled with CFR 0.152.
 */
package com.ma.villagers;

import com.google.common.collect.ImmutableSet;
import com.ma.ManaAndArtifice;
import com.ma.blocks.BlockInit;
import com.ma.config.GeneralModConfig;
import com.ma.items.ItemInit;
import com.ma.items.manaweaving.ItemManaweavingPattern;
import com.ma.items.ritual.ItemThaumaturgicLink;
import com.ma.items.runes.ItemRunescribingRecipe;
import com.ma.recipes.manaweaving.ManaweavingPattern;
import com.ma.recipes.manaweaving.ManaweavingPatternSerializer;
import com.ma.recipes.runeforging.RunescribingRecipe;
import com.ma.recipes.runeforging.RunescribingRecipeSerializer;
import com.ma.villagers.RandomTradeBuilder;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.village.PointOfInterestType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="mana-and-artifice", bus=Mod.EventBusSubscriber.Bus.MOD)
public class VillagerRegistry {
    private static PointOfInterestType SPELLMONGER_POINT_OF_INTEREST = null;
    public static VillagerProfession SPELLMONGER = null;
    private static PointOfInterestType RITUALIST_POINT_OF_INTEREST = null;
    public static VillagerProfession RITUALIST = null;
    private static PointOfInterestType MANAWEAVER_POINT_OF_INTEREST = null;
    public static VillagerProfession MANAWEAVER = null;

    @SubscribeEvent
    public static void registerVillagerProfession(RegistryEvent.Register<VillagerProfession> event) {
        SPELLMONGER = VillagerRegistry.register("spellmonger", SPELLMONGER_POINT_OF_INTEREST);
        event.getRegistry().register((IForgeRegistryEntry)SPELLMONGER);
        RITUALIST = VillagerRegistry.register("ritualist", RITUALIST_POINT_OF_INTEREST);
        event.getRegistry().register((IForgeRegistryEntry)RITUALIST);
        MANAWEAVER = VillagerRegistry.register("manaweaver", MANAWEAVER_POINT_OF_INTEREST);
        event.getRegistry().register((IForgeRegistryEntry)MANAWEAVER);
        ManaAndArtifice.LOGGER.info("M&A -> Villager Professions Registered");
    }

    @SubscribeEvent
    public static void registerPointOfInterest(RegistryEvent.Register<PointOfInterestType> event) {
        SPELLMONGER_POINT_OF_INTEREST = VillagerRegistry.register("spellmonger_poi", (Block)BlockInit.RUNEFORGE.get());
        event.getRegistry().register((IForgeRegistryEntry)SPELLMONGER_POINT_OF_INTEREST);
        RITUALIST_POINT_OF_INTEREST = VillagerRegistry.register("ritualist_poi", (Block)BlockInit.RUNESCRIBING_TABLE.get());
        event.getRegistry().register((IForgeRegistryEntry)RITUALIST_POINT_OF_INTEREST);
        MANAWEAVER_POINT_OF_INTEREST = VillagerRegistry.register("manaweaver_poi", (Block)BlockInit.MANAWEAVING_ALTAR.get());
        event.getRegistry().register((IForgeRegistryEntry)MANAWEAVER_POINT_OF_INTEREST);
        try {
            Method method = null;
            for (Method m : PointOfInterestType.class.getDeclaredMethods()) {
                if (m.getParameterCount() != 1 || m.getParameterTypes()[0] != PointOfInterestType.class || m.getReturnType() != PointOfInterestType.class) continue;
                method = m;
                break;
            }
            if (method != null) {
                method.setAccessible(true);
                method.invoke(null, SPELLMONGER_POINT_OF_INTEREST);
                method.invoke(null, RITUALIST_POINT_OF_INTEREST);
                method.invoke(null, MANAWEAVER_POINT_OF_INTEREST);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ManaAndArtifice.LOGGER.info("M&A -> Villager POI Registered");
    }

    private static VillagerProfession register(String professionNameIn, PointOfInterestType pointOfInterestIn) {
        try {
            Constructor ctor = VillagerProfession.class.getDeclaredConstructor(String.class, PointOfInterestType.class, ImmutableSet.class, ImmutableSet.class, SoundEvent.class);
            ctor.setAccessible(true);
            VillagerProfession profession = (VillagerProfession)ctor.newInstance(professionNameIn, pointOfInterestIn, ImmutableSet.of(), ImmutableSet.of(), null);
            profession.setRegistryName(new ResourceLocation("mana-and-artifice", professionNameIn));
            return profession;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static PointOfInterestType register(String nameIn, Block block) {
        try {
            Constructor ctor = PointOfInterestType.class.getDeclaredConstructor(String.class, Set.class, Integer.TYPE, Integer.TYPE);
            ctor.setAccessible(true);
            PointOfInterestType pointOfInterestType = (PointOfInterestType)ctor.newInstance(nameIn, ImmutableSet.copyOf((Collection)block.func_176194_O().func_177619_a()), 1, 1);
            pointOfInterestType.setRegistryName(new ResourceLocation("mana-and-artifice", nameIn));
            return pointOfInterestType;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Mod.EventBusSubscriber(modid="mana-and-artifice", bus=Mod.EventBusSubscriber.Bus.FORGE)
    static class VillagerTradesHandler {
        VillagerTradesHandler() {
        }

        @SubscribeEvent
        public static void registerTrades(VillagerTradesEvent event) {
            if (event.getType() == SPELLMONGER) {
                ((List)event.getTrades().get(1)).add(new RandomTradeBuilder(8, 10, 0.05f).setPrice((Item)ItemInit.VINTEUM_INGOT.get(), 5, 5).setForSale((Item)ItemInit.GUIDE_BOOK.get(), 1, 1).build());
                VillagerTradesHandler.addRecipeTrades(event, 2, 5, 1, VillagerTradesHandler::getRandomFlower);
                VillagerTradesHandler.addRecipeTrades(event, 2, 5, 1, r -> new ItemStack((IItemProvider)ItemInit.VINTEUM_DUST.get()));
                System.out.println("Registered Trades");
            } else if (event.getType() == RITUALIST) {
                VillagerTradesHandler.addRecipeTrades(event, 1, 5, 3, VillagerTradesHandler::getRandomRunescribingRecipe);
                VillagerTradesHandler.addRecipeTrades(event, 2, 5, 1, r -> new ItemStack((IItemProvider)ItemInit.RUNE_PATTERN.get()));
            } else if (event.getType() == MANAWEAVER) {
                VillagerTradesHandler.addRecipeTrades(event, 1, 5, 3, VillagerTradesHandler::getRandomManaweavingRecipe);
                VillagerTradesHandler.addRecipeTrades(event, 1, 1, 1, r -> new ItemStack((IItemProvider)ItemInit.MANAWEAVER_WAND.get()));
            } else if (event.getType() == VillagerProfession.field_221160_j) {
                if (((Boolean)GeneralModConfig.MA_MODIFY_VILLAGER_TRADES.get()).booleanValue()) {
                    VillagerTradesHandler.removeLibrarianTrades(event);
                    ManaAndArtifice.LOGGER.info("Mana And Artifice >> Applied villager librarian balance changes.");
                } else {
                    ManaAndArtifice.LOGGER.info("Mana And Artifice >> Skipped villager librarian balance changes as per config.");
                }
            } else if (event.getType() == VillagerProfession.field_221154_d) {
                VillagerTradesHandler.addRecipeTrades(event, 1, 5, 15, VillagerTradesHandler::getRandomThaumaturgicLink);
            }
        }

        private static void addRecipeTrades(VillagerTradesEvent event, int minLvl, int maxLvl, int numRolls, Function<Random, ItemStack> generator) {
            for (int i = minLvl; i <= maxLvl; ++i) {
                for (int r = 0; r < numRolls; ++r) {
                    ((List)event.getTrades().get(i)).add(new RandomTradeBuilder(8, 10, 0.05f).setEmeraldPrice(1).setForSale(generator).build());
                }
            }
        }

        private static void removeLibrarianTrades(VillagerTradesEvent event) {
            event.getTrades().forEach((i, t) -> {
                if (i > 2) {
                    return;
                }
                ArrayList<VillagerTrades.ITrade> toRemove = new ArrayList<VillagerTrades.ITrade>();
                for (VillagerTrades.ITrade trade : t) {
                    if (!trade.getClass().getCanonicalName().equals("net.minecraft.entity.merchant.villager.VillagerTrades.EnchantedBookForEmeraldsTrade")) continue;
                    toRemove.add(trade);
                }
                t.removeAll(toRemove);
            });
        }

        @SubscribeEvent
        public static void registerTrades(WandererTradesEvent event) {
            event.getRareTrades().add(new RandomTradeBuilder(8, 10, 0.05f).setPrice((Item)ItemInit.VINTEUM_INGOT.get(), 5, 5).setForSale((Item)ItemInit.GUIDE_BOOK.get(), 1, 1).build());
            event.getRareTrades().add(new RandomTradeBuilder(8, 10, 0.05f).setEmeraldPrice(1).setForSale(VillagerTradesHandler::getRandomRunescribingRecipe).build());
            event.getRareTrades().add(new RandomTradeBuilder(8, 10, 0.05f).setEmeraldPrice(1).setForSale(VillagerTradesHandler::getRandomRunescribingRecipe).build());
            event.getRareTrades().add(new RandomTradeBuilder(8, 10, 0.05f).setEmeraldPrice(1).setForSale(VillagerTradesHandler::getRandomRunescribingRecipe).build());
            event.getRareTrades().add(new RandomTradeBuilder(8, 10, 0.05f).setEmeraldPrice(1).setForSale(VillagerTradesHandler::getRandomRunescribingRecipe).build());
            event.getRareTrades().add(new RandomTradeBuilder(8, 10, 0.05f).setEmeraldPrice(1).setForSale(VillagerTradesHandler::getRandomManaweavingRecipe).build());
            event.getRareTrades().add(new RandomTradeBuilder(8, 10, 0.05f).setEmeraldPrice(1).setForSale(VillagerTradesHandler::getRandomManaweavingRecipe).build());
            event.getRareTrades().add(new RandomTradeBuilder(8, 10, 0.05f).setEmeraldPrice(1).setForSale(VillagerTradesHandler::getRandomManaweavingRecipe).build());
            event.getRareTrades().add(new RandomTradeBuilder(8, 10, 0.05f).setEmeraldPrice(1).setForSale(VillagerTradesHandler::getRandomManaweavingRecipe).build());
            System.out.println("Registered Wandering Trader Trades");
        }

        public static ItemStack getRandomRunescribingRecipe(Random rand) {
            ItemStack trade = new ItemStack((IItemProvider)ItemInit.RECIPE_SCRAP_RUNESCRIBING.get());
            ItemRunescribingRecipe cfr_ignored_0 = (ItemRunescribingRecipe)ItemInit.RECIPE_SCRAP_RUNESCRIBING.get();
            ItemRunescribingRecipe.setRecipe(trade, (RunescribingRecipe)RunescribingRecipeSerializer.ALL_RECIPES.values().stream().collect(Collectors.collectingAndThen(Collectors.toList(), collected -> {
                Collections.shuffle(collected);
                return collected.stream();
            })).limit(1L).collect(Collectors.toList()).get(0));
            return trade;
        }

        public static ItemStack getRandomManaweavingRecipe(Random rand) {
            ItemStack trade = new ItemStack((IItemProvider)ItemInit.RECIPE_SCRAP_MANAWEAVING_PATTERN.get());
            ItemManaweavingPattern cfr_ignored_0 = (ItemManaweavingPattern)ItemInit.RECIPE_SCRAP_MANAWEAVING_PATTERN.get();
            ItemManaweavingPattern.setRecipe(trade, (ManaweavingPattern)ManaweavingPatternSerializer.ALL_RECIPES.values().stream().collect(Collectors.collectingAndThen(Collectors.toList(), collected -> {
                Collections.shuffle(collected);
                return collected.stream();
            })).limit(1L).collect(Collectors.toList()).get(0));
            return trade;
        }

        public static ItemStack getRandomThaumaturgicLink(Random rand) {
            return ((ItemThaumaturgicLink)ItemInit.THAUMATURGIC_LINK.get()).getRandomLink();
        }

        public static ItemStack getRandomFlower(Random rand) {
            ResourceLocation[] flowers = new ResourceLocation[]{new ResourceLocation("mana-and-artifice", "aum"), new ResourceLocation("mana-and-artifice", "cerublossom"), new ResourceLocation("mana-and-artifice", "wakebloom"), new ResourceLocation("mana-and-artifice", "desert_nova"), new ResourceLocation("mana-and-artifice", "tarma_root")};
            return new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(flowers[rand.nextInt(flowers.length)]));
        }
    }
}

