/*
 * Decompiled with CFR 0.152.
 */
package com.ma.worldgen.structures;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.ma.worldgen.structures.MAConfiguredStructures;
import com.ma.worldgen.structures.MAGenericStructure;
import com.ma.worldgen.structures.registry.CouncilLibrary;
import com.ma.worldgen.structures.registry.DemonFortress;
import com.ma.worldgen.structures.registry.FairyGlade;
import com.ma.worldgen.structures.registry.PotionHut;
import com.ma.worldgen.structures.registry.RitualCircleDesert;
import com.ma.worldgen.structures.registry.RitualCircleForest;
import com.ma.worldgen.structures.registry.RitualCircleTundra;
import com.ma.worldgen.structures.registry.WistfulRunesmithRuin;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class MAStructures {
    public static final DeferredRegister<Structure<?>> DEFERRED_REGISTRY_STRUCTURE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"mana-and-artifice");
    public static final RegistryObject<MAGenericStructure> WISTFUL_RUNESMITH = MAStructures.setupStructure("wistful_runesmith", () -> new WistfulRunesmithRuin((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<MAGenericStructure> POTION_HUT = MAStructures.setupStructure("potion_hut", () -> new PotionHut((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<MAGenericStructure> RITUAL_CIRCLE_DESERT = MAStructures.setupStructure("ritual_circle_desert", () -> new RitualCircleDesert((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<MAGenericStructure> RITUAL_CIRCLE_FOREST = MAStructures.setupStructure("ritual_circle_forest", () -> new RitualCircleForest((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<MAGenericStructure> RITUAL_CIRCLE_TUNDRA = MAStructures.setupStructure("ritual_circle_tundra", () -> new RitualCircleTundra((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<MAGenericStructure> FAIRY_GLADE = MAStructures.setupStructure("fairy_glade", () -> new FairyGlade((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<MAGenericStructure> DEMON_FORTRESS = MAStructures.setupStructure("demon_fortress", () -> new DemonFortress((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<MAGenericStructure> COUNCIL_LIBRARY = MAStructures.setupStructure("council_library", () -> new CouncilLibrary((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));

    public static HashMap<MAGenericStructure, StructureFeature<?, ?>> getAllStructures() {
        HashMap map = new HashMap();
        map.put((MAGenericStructure)WISTFUL_RUNESMITH.get(), MAConfiguredStructures.CONFIGURED_WISTFUL_RUNESMITH);
        map.put((MAGenericStructure)POTION_HUT.get(), MAConfiguredStructures.CONFIGURED_POTION_HUT);
        map.put((MAGenericStructure)RITUAL_CIRCLE_DESERT.get(), MAConfiguredStructures.CONFIGURED_RITUAL_CIRCLE_DESERT);
        map.put((MAGenericStructure)RITUAL_CIRCLE_FOREST.get(), MAConfiguredStructures.CONFIGURED_RITUAL_CIRCLE_FOREST);
        map.put((MAGenericStructure)RITUAL_CIRCLE_TUNDRA.get(), MAConfiguredStructures.CONFIGURED_RITUAL_CIRCLE_TUNDRA);
        map.put((MAGenericStructure)FAIRY_GLADE.get(), MAConfiguredStructures.CONFIGURED_FAIRY_GLADE);
        map.put((MAGenericStructure)DEMON_FORTRESS.get(), MAConfiguredStructures.CONFIGURED_DEMON_FORTRESS);
        map.put((MAGenericStructure)COUNCIL_LIBRARY.get(), MAConfiguredStructures.CONFIGURED_COUNCIL_LIBRARY);
        return map;
    }

    private static <T extends Structure<?>> RegistryObject<T> setupStructure(String name, Supplier<T> structure) {
        return DEFERRED_REGISTRY_STRUCTURE.register(name, structure);
    }

    public static void setupStructures() {
        MAStructures.setupStructure((Structure)WISTFUL_RUNESMITH.get(), new StructureSeparationSettings(40, 25, 945872597), true);
        MAStructures.setupStructure((Structure)POTION_HUT.get(), new StructureSeparationSettings(61, 29, 860566210), false);
        MAStructures.setupStructure((Structure)RITUAL_CIRCLE_DESERT.get(), new StructureSeparationSettings(43, 21, 686429024), true);
        MAStructures.setupStructure((Structure)RITUAL_CIRCLE_FOREST.get(), new StructureSeparationSettings(51, 32, 987533046), true);
        MAStructures.setupStructure((Structure)RITUAL_CIRCLE_TUNDRA.get(), new StructureSeparationSettings(57, 41, 395551335), true);
        MAStructures.setupStructure((Structure)FAIRY_GLADE.get(), new StructureSeparationSettings(44, 27, 587065072), true);
        MAStructures.setupStructure((Structure)DEMON_FORTRESS.get(), new StructureSeparationSettings(44, 27, 632798833), true);
        MAStructures.setupStructure((Structure)COUNCIL_LIBRARY.get(), new StructureSeparationSettings(44, 27, 281221174), true);
    }

    public static <F extends Structure<?>> void setupStructure(F structure, StructureSeparationSettings structureSeparationSettings, boolean transformSurroundingLand) {
        Structure.field_236365_a_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        }
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)structureSeparationSettings).build();
    }
}

