/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcda.items.armor;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_5134;

public class ThiefArmorItem
extends class_1738 {
    private static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    private final boolean base;
    private final boolean unique;
    private final int protection;
    private final float toughness;
    private final Multimap<class_1320, class_1322> attributeModifiers;

    public ThiefArmorItem(class_1741 armorMaterial, class_1304 slot, class_1792.class_1793 settings, boolean base, boolean unique, String id) {
        super(armorMaterial, slot, settings);
        this.base = base;
        this.unique = unique;
        this.protection = armorMaterial.method_7697(slot);
        this.toughness = armorMaterial.method_7700();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID uuid = ARMOR_MODIFIERS[slot.method_5927()];
        builder.put((Object)class_5134.field_23724, (Object)new class_1322(uuid, "Armor modifier", (double)this.protection, class_1322.class_1323.field_6328));
        builder.put((Object)class_5134.field_23725, (Object)new class_1322(uuid, "Armor toughness", (double)this.toughness, class_1322.class_1323.field_6328));
        if (this.field_21976 > 0.0f) {
            builder.put((Object)class_5134.field_23718, (Object)new class_1322(uuid, "Armor knockback resistance", (double)this.field_21976, class_1322.class_1323.field_6328));
        }
        if (this.unique) {
            builder.put((Object)class_5134.field_23723, (Object)new class_1322(uuid, "Armor attack speed boost", 0.0375, class_1322.class_1323.field_6330));
        }
        this.attributeModifiers = builder.build();
        class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)new class_2960("mcda", id), (Object)((Object)this));
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        return slot == this.field_7880 ? this.attributeModifiers : super.method_7844(slot);
    }

    public class_1814 method_7862(class_1799 itemStack) {
        if (this.unique) {
            return class_1814.field_8903;
        }
        return class_1814.field_8907;
    }

    public void method_7851(class_1799 itemStack, class_1937 world, List<class_2561> tooltip, class_1836 tooltipContext) {
        super.method_7851(itemStack, world, tooltip, tooltipContext);
        if (this.base) {
            tooltip.add((class_2561)new class_2588("item.mcda.thief_armor.tooltip_1"));
            tooltip.add((class_2561)new class_2588("item.mcda.thief_armor.tooltip_2"));
        }
        if (this.unique) {
            tooltip.add((class_2561)new class_2588("item.mcda.spider_armor.tooltip_1"));
            tooltip.add((class_2561)new class_2588("item.mcda.spider_armor.tooltip_2"));
            tooltip.add((class_2561)new class_2588("item.mcda.spider_armor.tooltip_3"));
        }
    }
}

