/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.api;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.abilities.IAbility;
import mchorse.metamorph.api.abilities.IAction;
import mchorse.metamorph.api.abilities.IAttackAbility;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class MorphSettings {
    public static final MorphSettings DEFAULT = new MorphSettings();
    public List<IAbility> abilities = new ArrayList<IAbility>();
    public IAttackAbility attack;
    public IAction action;
    public int health = 20;
    public float speed = 0.1f;
    public boolean hostile;
    public boolean hands;
    public boolean updates = true;

    public boolean equals(Object obj) {
        if (obj instanceof MorphSettings) {
            MorphSettings settings = (MorphSettings)obj;
            return this.abilities.equals(settings.abilities) && Objects.equals(this.action, settings.action) && Objects.equals(this.attack, settings.attack) && this.health == settings.health && this.speed == settings.speed && this.hostile == settings.hostile && this.updates == settings.updates;
        }
        return super.equals(obj);
    }

    public MorphSettings copy() {
        MorphSettings settings = new MorphSettings();
        settings.copy(this);
        return settings;
    }

    public void copy(MorphSettings setting) {
        this.abilities.clear();
        this.abilities.addAll(setting.abilities);
        this.action = setting.action;
        this.attack = setting.attack;
        this.health = setting.health;
        this.speed = setting.speed;
        this.hostile = setting.hostile;
        this.hands = setting.hands;
        this.updates = setting.updates;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.abilities.size());
        for (IAbility ability : this.abilities) {
            String string = MorphSettings.getKey(MorphManager.INSTANCE.abilities, ability);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(string == null ? "" : string));
        }
        String action = MorphSettings.getKey(MorphManager.INSTANCE.actions, this.action);
        String attack = MorphSettings.getKey(MorphManager.INSTANCE.attacks, this.attack);
        buf.writeBoolean(action != null);
        if (action != null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)action);
        }
        buf.writeBoolean(attack != null);
        if (attack != null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)attack);
        }
        buf.writeInt(this.health);
        buf.writeFloat(this.speed);
        buf.writeBoolean(this.hostile);
        buf.writeBoolean(this.hands);
        buf.writeBoolean(this.updates);
    }

    public void fromBytes(ByteBuf buf) {
        this.abilities.clear();
        int c = buf.readInt();
        for (int i = 0; i < c; ++i) {
            IAbility ability = MorphManager.INSTANCE.abilities.get(ByteBufUtils.readUTF8String((ByteBuf)buf));
            if (ability == null) continue;
            this.abilities.add(ability);
        }
        if (buf.readBoolean()) {
            String action = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.action = MorphManager.INSTANCE.actions.get(action);
        }
        if (buf.readBoolean()) {
            String attack = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.attack = MorphManager.INSTANCE.attacks.get(attack);
        }
        this.health = buf.readInt();
        this.speed = buf.readFloat();
        this.hostile = buf.readBoolean();
        this.hands = buf.readBoolean();
        this.updates = buf.readBoolean();
    }

    public void toNBT(NBTTagCompound tag) {
        if (!this.abilities.isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (IAbility ability : this.abilities) {
                list.func_74742_a((NBTBase)new NBTTagString(MorphSettings.getKey(MorphManager.INSTANCE.abilities, ability)));
            }
            tag.func_74782_a("Abilities", (NBTBase)list);
        }
        if (this.attack != null) {
            tag.func_74778_a("Attack", MorphSettings.getKey(MorphManager.INSTANCE.attacks, this.attack));
        }
        if (this.action != null) {
            tag.func_74778_a("Action", MorphSettings.getKey(MorphManager.INSTANCE.actions, this.action));
        }
        if (this.health != 20) {
            tag.func_74768_a("HP", this.health);
        }
        if (this.speed != 0.1f) {
            tag.func_74776_a("Speed", this.speed);
        }
        if (this.hostile) {
            tag.func_74757_a("Hostile", this.hostile);
        }
        if (this.hands) {
            tag.func_74757_a("Hands", this.hands);
        }
        if (!this.updates) {
            tag.func_74757_a("Updates", this.updates);
        }
    }

    public void fromNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("Abilities")) {
            NBTTagList list = tag.func_150295_c("Abilities", 8);
            this.abilities.clear();
            for (int i = 0; i < list.func_74745_c(); ++i) {
                IAbility ability = MorphManager.INSTANCE.abilities.get(list.func_150307_f(i));
                if (ability == null) continue;
                this.abilities.add(ability);
            }
        }
        if (tag.func_74764_b("Attack")) {
            this.attack = MorphManager.INSTANCE.attacks.get(tag.func_74779_i("Attack"));
        }
        if (tag.func_74764_b("Action")) {
            this.action = MorphManager.INSTANCE.actions.get(tag.func_74779_i("Action"));
        }
        if (tag.func_74764_b("HP")) {
            this.health = tag.func_74762_e("HP");
        }
        if (tag.func_74764_b("Speed")) {
            this.speed = tag.func_74760_g("Speed");
        }
        if (tag.func_74764_b("Hostile")) {
            this.hostile = tag.func_74767_n("Hostile");
        }
        if (tag.func_74764_b("Hands")) {
            this.hands = tag.func_74767_n("Hands");
        }
        if (tag.func_74764_b("Updates")) {
            this.updates = tag.func_74767_n("Updates");
        }
    }

    public static <T> String getKey(Map<String, T> map, T value) {
        if (value == null) {
            return null;
        }
        for (Map.Entry<String, T> entry : map.entrySet()) {
            if (entry.getValue() != value) continue;
            return entry.getKey();
        }
        return null;
    }
}

