/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.api;

import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import mchorse.mclib.utils.NBTUtils;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.MorphSettings;
import mchorse.metamorph.api.events.RegisterBlacklistEvent;
import mchorse.metamorph.api.events.RegisterRemapEvent;
import mchorse.metamorph.api.events.RegisterSettingsEvent;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.api.morphs.utils.ISyncableMorph;
import mchorse.metamorph.bodypart.IBodyPartProvider;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MorphUtils {
    public static void generateFile(File config, String content) {
        config.getParentFile().mkdirs();
        try {
            PrintWriter writer = new PrintWriter(config);
            writer.print(content);
            writer.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static Set<String> reloadBlacklist() {
        RegisterBlacklistEvent event = new RegisterBlacklistEvent();
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.blacklist;
    }

    public static Map<String, MorphSettings> reloadMorphSettings() {
        RegisterSettingsEvent event = new RegisterSettingsEvent();
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.settings;
    }

    public static Map<String, String> reloadRemapper() {
        RegisterRemapEvent event = new RegisterRemapEvent();
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.map;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean render(AbstractMorph morph, EntityLivingBase entity, double x, double y, double z, float yaw, float partialTick) {
        if (morph == null || morph.errorRendering) {
            return false;
        }
        try {
            morph.render(entity, x, y, z, yaw, partialTick);
            return true;
        }
        catch (Exception e) {
            morph.errorRendering = true;
            return false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean renderOnScreen(AbstractMorph morph, EntityPlayer player, int x, int y, float scale, float alpha) {
        if (morph == null || morph.errorRendering) {
            return false;
        }
        try {
            morph.renderOnScreen(player, x, y, scale, alpha);
            return true;
        }
        catch (Exception e) {
            morph.errorRendering = true;
            return false;
        }
    }

    public static AbstractMorph copy(AbstractMorph morph) {
        return morph == null ? null : morph.copy();
    }

    public static boolean pause(AbstractMorph morph, AbstractMorph previous, int offset) {
        if (morph instanceof ISyncableMorph) {
            ((ISyncableMorph)((Object)morph)).pause(previous, offset);
            return true;
        }
        if (morph instanceof IBodyPartProvider) {
            ((IBodyPartProvider)((Object)morph)).getBodyPart().pause(previous, offset);
            return true;
        }
        return false;
    }

    public static NBTTagCompound toNBT(AbstractMorph morph) {
        if (morph == null) {
            return null;
        }
        return morph.toNBT();
    }

    public static void morphToBuf(ByteBuf buffer, AbstractMorph morph) {
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)(morph == null ? null : morph.toNBT()));
    }

    public static AbstractMorph morphFromBuf(ByteBuf buffer) {
        return MorphManager.INSTANCE.morphFromNBT(NBTUtils.readInfiniteTag((ByteBuf)buffer));
    }
}

