/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.api.creative;

import java.util.ArrayList;
import java.util.List;
import mchorse.metamorph.api.creative.sections.MorphSection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class MorphList {
    public List<MorphSection> sections = new ArrayList<MorphSection>();

    public void register(MorphSection section) {
        this.sections.add(section);
    }

    public void update(World world) {
        for (MorphSection section : this.sections) {
            section.update(world);
        }
    }

    public void reset() {
        for (MorphSection section : this.sections) {
            section.reset();
        }
    }

    public boolean keyTyped(EntityPlayer player, int keycode) {
        for (MorphSection section : this.sections) {
            if (!section.keyTyped(player, keycode)) continue;
            return true;
        }
        return false;
    }

    public <T> T getSection(Class<T> clazz) {
        for (MorphSection section : this.sections) {
            if (section.getClass() != clazz) continue;
            return clazz.cast(section);
        }
        return null;
    }
}

