/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.api.morphs;

import java.util.Objects;
import mchorse.metamorph.Metamorph;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.MorphSettings;
import mchorse.metamorph.api.abilities.IAbility;
import mchorse.metamorph.api.morphs.utils.Hitbox;
import mchorse.metamorph.entity.SoundHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractMorph {
    public String name = "";
    public String displayName = "";
    public boolean favorite = false;
    public int keybind = -1;
    public MorphSettings settings = MorphSettings.DEFAULT;
    public Hitbox hitbox = new Hitbox();
    public boolean errorRendering;

    @SideOnly(value=Side.CLIENT)
    public String getDisplayName() {
        if (this.displayName != null && !this.displayName.isEmpty()) {
            return this.displayName;
        }
        return this.getSubclassDisplayName();
    }

    @SideOnly(value=Side.CLIENT)
    protected String getSubclassDisplayName() {
        return this.name;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasCustomName() {
        return this.displayName != null && !this.displayName.isEmpty();
    }

    public boolean hasCustomSettings() {
        if (this.settings == MorphSettings.DEFAULT) {
            return false;
        }
        return this.settings != MorphManager.INSTANCE.activeSettings.get(this.name);
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void renderOnScreen(EntityPlayer var1, int var2, int var3, float var4, float var5);

    @SideOnly(value=Side.CLIENT)
    public abstract void render(EntityLivingBase var1, double var2, double var4, double var6, float var8, float var9);

    @SideOnly(value=Side.CLIENT)
    public boolean renderHand(EntityPlayer player, EnumHand hand) {
        return false;
    }

    public void update(EntityLivingBase target) {
        this.updateHitbox(target);
        if (this.settings.speed != 0.1f) {
            target.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)this.settings.speed);
        }
        for (IAbility ability : this.settings.abilities) {
            ability.update(target);
        }
    }

    public void morph(EntityLivingBase target) {
        for (IAbility ability : this.settings.abilities) {
            ability.onMorph(target);
        }
    }

    public void demorph(EntityLivingBase target) {
        for (IAbility ability : this.settings.abilities) {
            ability.onDemorph(target);
        }
    }

    protected void updateHitbox(EntityLivingBase target) {
        if (this.hitbox.enabled) {
            float height = target.func_70093_af() ? this.hitbox.sneakingHeight : this.hitbox.height;
            this.updateSize(target, this.hitbox.width, height, this.hitbox.eye);
        } else {
            this.updateUserHitbox(target);
        }
    }

    protected void updateUserHitbox(EntityLivingBase target) {
    }

    public void updateSize(EntityLivingBase target, float width, float height) {
        AbstractMorph.updateSizeDefault(target, width, height);
    }

    public void updateSize(EntityLivingBase target, float width, float height, float eyeFactor) {
        AbstractMorph.updateSizeDefault(target, width, height, eyeFactor);
    }

    public static void updateSizeDefault(EntityLivingBase target, float width, float height) {
        AbstractMorph.updateSizeDefault(target, width, height, 0.9f);
    }

    public static void updateSizeDefault(EntityLivingBase target, float width, float height, float eyeFactor) {
        float minEyeToHeadDifference = 0.1f;
        height = Math.max(height, minEyeToHeadDifference * 2.0f);
        if (target instanceof EntityPlayer && !Metamorph.disablePov.get()) {
            float eyeHeight = height * eyeFactor;
            if (eyeHeight + minEyeToHeadDifference > height) {
                eyeHeight = height - minEyeToHeadDifference;
            }
            ((EntityPlayer)target).eyeHeight = eyeHeight;
        }
        if (width != target.field_70130_N || height != target.field_70131_O) {
            AxisAlignedBB aabb = target.func_174813_aQ();
            target.field_70130_N = width;
            target.field_70131_O = height;
            target.func_174826_a(new AxisAlignedBB(target.field_70165_t - (double)(width / 2.0f), aabb.field_72338_b, target.field_70161_v - (double)(width / 2.0f), target.field_70165_t + (double)(width / 2.0f), aabb.field_72338_b + (double)height, target.field_70161_v + (double)(width / 2.0f)));
        }
    }

    public void action(EntityLivingBase target) {
        if (this.settings.action != null) {
            this.settings.action.execute(target, this);
        }
    }

    public void attack(Entity target, EntityLivingBase source) {
        if (this.settings.attack != null) {
            this.settings.attack.attack(target, source);
        }
    }

    public final AbstractMorph copy() {
        AbstractMorph morph = this.create();
        morph.copy(this);
        return morph;
    }

    public abstract AbstractMorph create();

    public void copy(AbstractMorph from) {
        this.name = from.name;
        this.displayName = from.displayName;
        this.favorite = from.favorite;
        this.keybind = from.keybind;
        this.settings = this.hasCustomSettings() ? from.settings.copy() : from.settings;
        this.hitbox.copy(from.hitbox);
    }

    public abstract float getWidth(EntityLivingBase var1);

    public abstract float getHeight(EntityLivingBase var1);

    public float getEyeHeight(EntityLivingBase target) {
        if (!Metamorph.disablePov.get()) {
            return this.getHeight(target) * 0.9f;
        }
        return 1.62f;
    }

    public final SoundEvent getHurtSound(EntityLivingBase target) {
        return this.getHurtSound(target, SoundHandler.GENERIC_DAMAGE);
    }

    public SoundEvent getHurtSound(EntityLivingBase target, DamageSource damageSource) {
        return null;
    }

    public SoundEvent getDeathSound(EntityLivingBase target) {
        return null;
    }

    public boolean hasCustomStepSound(EntityLivingBase target) {
        return false;
    }

    public void playStepSound(EntityLivingBase target) {
    }

    public void onChangeDimension(EntityPlayer player, int oldDim, int currentDim) {
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractMorph) {
            AbstractMorph morph = (AbstractMorph)obj;
            return Objects.equals(this.name, morph.name) && Objects.equals(this.displayName, morph.displayName) && Objects.equals(this.settings, morph.settings) && Objects.equals(this.hitbox, morph.hitbox);
        }
        return super.equals(obj);
    }

    public boolean canMerge(AbstractMorph morph) {
        return false;
    }

    public void afterMerge(AbstractMorph morph) {
    }

    protected void mergeBasic(AbstractMorph morph) {
        this.displayName = morph.displayName;
        this.settings = morph.settings;
        this.hitbox.copy(morph.hitbox);
    }

    public void reset() {
        this.hitbox.reset();
    }

    public final NBTTagCompound toNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        this.toNBT(tag);
        return tag;
    }

    public void toNBT(NBTTagCompound tag) {
        tag.func_74778_a("Name", this.name);
        if (this.hasCustomSettings()) {
            NBTTagCompound settings = new NBTTagCompound();
            this.settings.toNBT(settings);
            if (!settings.func_82582_d()) {
                tag.func_74782_a("Settings", (NBTBase)settings);
            }
        }
        if (this.displayName != null && !this.displayName.isEmpty()) {
            tag.func_74778_a("DisplayName", this.displayName);
        }
        if (this.favorite) {
            tag.func_74757_a("Favorite", this.favorite);
        }
        if (this.keybind >= 0) {
            tag.func_74768_a("Keybind", this.keybind);
        }
        if (!this.hitbox.isDefault()) {
            tag.func_74782_a("Hitbox", (NBTBase)this.hitbox.toNBT());
        }
    }

    public void fromNBT(NBTTagCompound tag) {
        this.reset();
        this.name = tag.func_74779_i("Name");
        if (tag.func_74764_b("Settings")) {
            this.settings = new MorphSettings();
            this.settings.fromNBT(tag.func_74775_l("Settings"));
        }
        if (tag.func_74764_b("DisplayName")) {
            this.displayName = tag.func_74779_i("DisplayName");
        }
        if (tag.func_74764_b("Favorite")) {
            this.favorite = tag.func_74767_n("Favorite");
        }
        if (tag.func_74764_b("Keybind")) {
            this.keybind = tag.func_74762_e("Keybind");
        }
        if (tag.func_74764_b("Hitbox")) {
            this.hitbox.fromNBT(tag.func_74775_l("Hitbox"));
        }
    }
}

