/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.api.morphs.utils;

import mchorse.mclib.utils.Interpolation;
import mchorse.mclib.utils.MathUtils;
import net.minecraft.nbt.NBTTagCompound;

public class Animation {
    public boolean animates;
    public boolean ignored;
    public int duration = 10;
    public Interpolation interp = Interpolation.LINEAR;
    public int progress;
    public boolean paused;

    public void pause() {
        this.pause(0);
    }

    public void pause(int progress) {
        this.paused = true;
        this.progress = progress;
    }

    public float getFactor(float partialTicks) {
        if (!this.animates) {
            return 1.0f;
        }
        return MathUtils.clamp((float)(((float)this.progress + (this.paused ? 0.0f : partialTicks)) / (float)this.duration), (float)0.0f, (float)1.0f);
    }

    public void reset() {
        this.progress = this.duration;
    }

    public void merge(Animation animation) {
        this.copy(animation);
        this.progress = 0;
    }

    public void copy(Animation animation) {
        this.animates = animation.animates;
        this.duration = animation.duration;
        this.interp = animation.interp;
        this.ignored = animation.ignored;
        this.paused = animation.paused;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Animation) {
            Animation animation = (Animation)obj;
            return this.animates == animation.animates && this.duration == animation.duration && this.ignored == animation.ignored && this.interp == animation.interp;
        }
        return super.equals(obj);
    }

    public void update() {
        if (this.animates && !this.paused) {
            ++this.progress;
        }
    }

    public boolean isInProgress() {
        return this.animates && (this.paused || this.progress < this.duration);
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        if (this.animates) {
            tag.func_74757_a("Animates", this.animates);
        }
        if (this.ignored) {
            tag.func_74757_a("Ignored", this.ignored);
        }
        if (this.duration != 10) {
            tag.func_74768_a("Duration", this.duration);
        }
        if (this.interp != Interpolation.LINEAR) {
            tag.func_74768_a("Interp", this.interp.ordinal());
        }
        return tag;
    }

    public void fromNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("Animates")) {
            this.animates = tag.func_74767_n("Animates");
        }
        if (tag.func_74764_b("Ignored")) {
            this.ignored = tag.func_74767_n("Ignored");
        }
        if (tag.func_74764_b("Duration")) {
            this.duration = tag.func_74762_e("Duration");
        }
        if (tag.func_74764_b("Interp")) {
            this.interp = Interpolation.values()[tag.func_74762_e("Interp")];
        }
        this.reset();
    }
}

