/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.bodypart;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiSlotElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTransformations;
import mchorse.mclib.client.gui.framework.elements.list.GuiStringListElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiInventoryElement;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.mclib.utils.Direction;
import mchorse.mclib.utils.MathUtils;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.api.morphs.utils.IAnimationProvider;
import mchorse.metamorph.bodypart.BodyPart;
import mchorse.metamorph.bodypart.BodyPartManager;
import mchorse.metamorph.bodypart.GuiBodyPartListElement;
import mchorse.metamorph.bodypart.IBodyPartProvider;
import mchorse.metamorph.client.gui.creative.GuiNestedEdit;
import mchorse.metamorph.client.gui.editor.GuiAbstractMorph;
import mchorse.metamorph.client.gui.editor.GuiMorphPanel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiBodyPartEditor
extends GuiMorphPanel<AbstractMorph, GuiAbstractMorph> {
    public static List<BodyPart> buffer = new ArrayList<BodyPart>();
    protected GuiBodyPartListElement bodyParts;
    protected GuiNestedEdit pickMorph;
    protected GuiToggleElement useTarget;
    protected GuiToggleElement enabled;
    protected GuiToggleElement animate;
    protected GuiIconElement add;
    protected GuiIconElement dupe;
    protected GuiIconElement remove;
    protected GuiIconElement copy;
    protected GuiIconElement paste;
    protected GuiBodyPartTransformations transformations;
    protected GuiStringListElement limbs;
    protected GuiElement elements;
    protected GuiElement bottomEditor;
    protected BodyPartManager parts;
    protected BodyPart part;
    protected GuiInventoryElement inventory;
    protected GuiElement stacks;
    protected GuiSlotElement[] slots = new GuiSlotElement[6];

    public GuiBodyPartEditor(Minecraft mc, GuiAbstractMorph editor) {
        super(mc, editor);
        this.limbs = new GuiStringListElement(mc, str -> this.pickLimb((String)str.get(0)));
        this.bodyParts = new GuiBodyPartListElement(mc, part -> this.setPart(part.isEmpty() ? null : (BodyPart)part.get(0)));
        this.bodyParts.background().sorting();
        this.pickMorph = new GuiNestedEdit(mc, editing -> {
            BodyPart part = this.part;
            this.editor.morphs.nestEdit(part.morph.get(), (boolean)editing, morph -> {
                if (part != null) {
                    part.morph.setDirect(MorphUtils.copy(morph));
                }
            });
        });
        this.add = new GuiIconElement(mc, Icons.ADD, this::addPart);
        this.add.tooltip(IKey.lang((String)"metamorph.gui.body_parts.add_tooltip"));
        this.add.flex().w(20);
        this.dupe = new GuiIconElement(mc, Icons.DUPE, this::dupePart);
        this.dupe.tooltip(IKey.lang((String)"metamorph.gui.body_parts.dupe_tooltip"));
        this.remove = new GuiIconElement(mc, Icons.REMOVE, this::removePart);
        this.remove.tooltip(IKey.lang((String)"metamorph.gui.body_parts.remove_tooltip"));
        this.copy = new GuiIconElement(mc, Icons.COPY, this::copyParts);
        this.copy.tooltip(IKey.lang((String)"metamorph.gui.body_parts.copy_tooltip"));
        this.paste = new GuiIconElement(mc, Icons.PASTE, this::pasteParts);
        this.paste.tooltip(IKey.lang((String)"metamorph.gui.body_parts.paste_tooltip"));
        this.paste.flex().w(20);
        this.useTarget = new GuiToggleElement(mc, IKey.lang((String)"metamorph.gui.body_parts.use_target"), false, this::toggleTarget);
        this.enabled = new GuiToggleElement(mc, IKey.lang((String)"metamorph.gui.body_parts.enabled"), false, this::toggleEnabled);
        this.animate = new GuiToggleElement(mc, IKey.lang((String)"metamorph.gui.body_parts.animate"), false, this::toggleAnimate);
        this.animate.tooltip(IKey.lang((String)"metamorph.gui.body_parts.animate_tooltip"), Direction.LEFT);
        this.transformations = new GuiBodyPartTransformations(mc);
        int width = 110;
        GuiElement sidebar = new GuiElement(mc);
        sidebar.flex().relative((GuiElement)this).x(10).y(1.0f, -30).wh(width, 20).row(0).height(20);
        sidebar.add(new IGuiElement[]{this.add, this.dupe, this.remove, this.copy, this.paste});
        this.bottomEditor = new GuiElement(mc);
        this.bottomEditor.flex().relative((GuiElement)this).x(1.0f, -115).y(1.0f, -10).w(width).anchorY(1.0f);
        this.bottomEditor.flex().column(5).vertical().stretch();
        this.bottomEditor.add(new IGuiElement[]{this.enabled, this.animate, this.useTarget});
        this.transformations.flex().relative((IResizer)this.area).x(0.5f, -95).y(1.0f, -10).wh(190, 70).anchorY(1.0f);
        this.limbs.flex().relative((GuiElement)this).set(0.0f, 50.0f, (float)width, 90.0f).x(1.0f, -115).hTo((IResizer)this.bottomEditor.area, -5);
        this.pickMorph.flex().relative((GuiElement)this).set(0.0f, 10.0f, (float)width, 20.0f).x(1.0f, -115);
        this.bodyParts.flex().relative((GuiElement)this).set(10.0f, 22.0f, (float)width, 0.0f).hTo((IResizer)this.transformations.flex(), 1.0f, -20);
        this.elements = new GuiElement(mc).noCulling();
        this.elements.add(new IGuiElement[]{this.bottomEditor, this.limbs, this.pickMorph, this.transformations});
        this.add(new IGuiElement[]{sidebar, this.bodyParts, this.elements});
        this.stacks = new GuiElement(mc);
        this.stacks.flex().relative((GuiElement)this).x(0.5f).y(10).anchor(0.5f, 0.0f).row(5).resize();
        this.inventory = new GuiInventoryElement(mc, this::pickItem);
        this.inventory.flex().relative(this.stacks).x(0.5f, 0).y(1.0f, 10).anchor(0.5f, 0.0f).row(6);
        this.inventory.setVisible(false);
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = new GuiSlotElement(mc, i, this.inventory);
            this.stacks.add((IGuiElement)this.slots[i]);
        }
        this.elements.add(new IGuiElement[]{this.stacks, this.inventory});
    }

    protected void addPart(GuiIconElement b) {
        BodyPart part = new BodyPart();
        this.setupNewBodyPart(part);
        part.init();
        this.parts.parts.add(part);
        this.setPart(part);
        this.bodyParts.setCurrentDirect(part);
        this.bodyParts.update();
    }

    protected void setupNewBodyPart(BodyPart part) {
    }

    protected void dupePart(GuiIconElement b) {
        if (this.bodyParts.isDeselected()) {
            return;
        }
        BodyPart part = ((BodyPart)this.bodyParts.getCurrentFirst()).copy();
        part.init();
        this.parts.parts.add(part);
        this.setPart(part);
        this.bodyParts.setCurrentDirect(part);
        this.bodyParts.update();
    }

    protected void removePart(GuiIconElement b) {
        if (this.bodyParts.isDeselected()) {
            return;
        }
        List<BodyPart> parts = this.parts.parts;
        int index = -1;
        for (int i = 0; i < parts.size(); ++i) {
            if (parts.get(i) != this.part) continue;
            index = i;
            break;
        }
        if (index != -1) {
            parts.remove(this.part);
            this.bodyParts.update();
            --index;
            if (parts.size() >= 1) {
                this.setPart(parts.get(MathUtils.clamp((int)index, (int)0, (int)(parts.size() - 1))));
            } else {
                this.setPart(null);
            }
        }
        this.bodyParts.update();
    }

    protected void copyParts(GuiIconElement b) {
        buffer.clear();
        for (BodyPart part : this.parts.parts) {
            buffer.add(part.copy());
        }
    }

    protected void pasteParts(GuiIconElement b) {
        for (BodyPart part : buffer) {
            BodyPart clone = part.copy();
            this.parts.parts.add(clone);
            clone.init();
        }
        if (!this.parts.parts.isEmpty()) {
            this.setPart(this.parts.parts.get(this.parts.parts.size() - 1));
        }
        this.bodyParts.update();
    }

    protected void toggleTarget(GuiToggleElement b) {
        if (this.part != null) {
            this.part.useTarget = b.isToggled();
        }
    }

    protected void toggleEnabled(GuiToggleElement b) {
        if (this.part != null) {
            this.part.enabled = b.isToggled();
        }
    }

    protected void toggleAnimate(GuiToggleElement b) {
        if (this.part != null) {
            this.part.animate = b.isToggled();
        }
    }

    protected void pickItem(ItemStack stack) {
        if (this.part == null) {
            return;
        }
        GuiSlotElement element = this.inventory.linked;
        this.part.slots[element.slot] = element.stack = stack.func_190926_b() ? ItemStack.field_190927_a : stack.func_77946_l();
        this.inventory.unlink();
        this.part.updateEntity();
    }

    @Override
    public void fillData(AbstractMorph morph) {
        super.fillData(morph);
        if (morph instanceof IBodyPartProvider) {
            BodyPartManager manager;
            this.parts = manager = ((IBodyPartProvider)((Object)morph)).getBodyPart();
            this.bodyParts.setList(manager.parts);
            this.bodyParts.update();
        }
    }

    @Override
    public void startEditing() {
        super.startEditing();
        if (this.parts != null) {
            this.setPart(this.parts.parts.isEmpty() ? null : this.parts.parts.get(0));
        }
    }

    public void setLimbs(Collection<String> limbs) {
        this.limbs.clear();
        this.limbs.add(limbs);
        this.limbs.sort();
    }

    protected void setPart(BodyPart part) {
        this.part = part;
        this.elements.setVisible(part != null);
        if (this.part != null) {
            this.fillBodyPart(part);
            this.limbs.setCurrent((Object)part.limb);
            this.bodyParts.setCurrentDirect(part);
            this.pickMorph.setMorph(part.morph.get());
        }
    }

    protected void pickLimb(String str) {
        this.part.limb = str;
    }

    public void fillBodyPart(BodyPart part) {
        if (part != null) {
            this.bottomEditor.removeAll();
            if (this.morph instanceof IAnimationProvider) {
                this.bottomEditor.add(new IGuiElement[]{this.enabled, this.animate, this.useTarget});
            } else {
                this.bottomEditor.add(new IGuiElement[]{this.enabled, this.useTarget});
            }
            this.elements.resize();
            this.transformations.setBodyPart(part);
            this.enabled.toggled(part.enabled);
            this.useTarget.toggled(part.useTarget);
            this.animate.toggled(part.animate);
            for (int i = 0; i < this.slots.length; ++i) {
                this.slots[i].stack = part.slots[i];
            }
        }
    }

    public void draw(GuiContext context) {
        this.font.func_175063_a(I18n.func_135052_a((String)"metamorph.gui.body_parts.parts", (Object[])new Object[0]), (float)this.bodyParts.area.x, (float)(this.bodyParts.area.y - 12), 0xFFFFFF);
        if (this.elements.isVisible()) {
            Gui.func_73734_a((int)this.limbs.area.x, (int)this.limbs.area.y, (int)this.limbs.area.ex(), (int)this.limbs.area.ey(), (int)-2013265920);
            this.font.func_175063_a(I18n.func_135052_a((String)"metamorph.gui.body_parts.limbs", (Object[])new Object[0]), (float)this.limbs.area.x, (float)(this.limbs.area.y - 12), 0xFFFFFF);
        }
        super.draw(context);
    }

    @Override
    public void fromNBT(NBTTagCompound tag) {
        super.fromNBT(tag);
        this.bodyParts.setIndex(tag.func_74762_e("Index"));
        BodyPart part = (BodyPart)this.bodyParts.getCurrentFirst();
        if (part != null) {
            this.setPart(part);
        }
    }

    @Override
    public NBTTagCompound toNBT() {
        NBTTagCompound tag = super.toNBT();
        tag.func_74768_a("Index", this.bodyParts.getIndex());
        return tag;
    }

    public static class GuiBodyPartTransformations
    extends GuiTransformations {
        public BodyPart part;

        public GuiBodyPartTransformations(Minecraft mc) {
            super(mc);
        }

        public void setBodyPart(BodyPart part) {
            this.part = part;
            if (part != null) {
                this.fillT(part.translate.x, part.translate.y, part.translate.z);
                this.fillS(part.scale.x, part.scale.y, part.scale.z);
                this.fillR(part.rotate.x, part.rotate.y, part.rotate.z);
            }
        }

        public void setT(double x, double y, double z) {
            this.part.translate.x = (float)x;
            this.part.translate.y = (float)y;
            this.part.translate.z = (float)z;
        }

        public void setS(double x, double y, double z) {
            this.part.scale.x = (float)x;
            this.part.scale.y = (float)y;
            this.part.scale.z = (float)z;
        }

        public void setR(double x, double y, double z) {
            this.part.rotate.x = (float)x;
            this.part.rotate.y = (float)y;
            this.part.rotate.z = (float)z;
        }
    }
}

