/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.capabilities.render;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class EntitySelector {
    public boolean enabled = true;
    public String name = "";
    public String type = "";
    public NBTTagCompound match;
    public NBTTagCompound morph;
    public long time = System.currentTimeMillis();

    public void updateTime() {
        this.time = System.currentTimeMillis();
    }

    public boolean matches(EntityLivingBase target) {
        boolean matchesType;
        if (target == null || !this.enabled) {
            return false;
        }
        String nameTag = target.func_70005_c_();
        ResourceLocation entityName = EntityList.func_191301_a((Entity)target);
        if (entityName == null) {
            entityName = new ResourceLocation(target instanceof EntityPlayer ? "player" : "");
        }
        String n = this.name;
        String t = this.type;
        boolean negativeName = n.startsWith("!");
        boolean negativeType = t.startsWith("!");
        if (negativeName) {
            n = n.substring(1);
        }
        if (negativeType) {
            t = t.substring(1);
        }
        ResourceLocation rt = new ResourceLocation(t);
        boolean matchesName = this.name.isEmpty() || negativeName != nameTag.equals(n);
        boolean bl = matchesType = this.type.equals("*") || negativeType != entityName.equals((Object)rt);
        if (matchesName && matchesType) {
            if (this.match != null && !this.match.func_82582_d()) {
                return this.match(target.func_189511_e(new NBTTagCompound()));
            }
            return true;
        }
        return false;
    }

    private boolean match(NBTTagCompound entityTag) {
        for (String key : this.match.func_150296_c()) {
            NBTBase entityValue;
            NBTBase value = this.match.func_74781_a(key);
            if (value.equals((Object)(entityValue = entityTag.func_74781_a(key)))) continue;
            return false;
        }
        return true;
    }
}

